/*
 * #%L
 * IsisFish
 * 
 * $Id: ScriptTreeCellRenderer.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script.model;

import java.awt.Color;
import java.awt.Component;
import java.io.File;

import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.vcs.VCSException;
import fr.ifremer.isisfish.vcs.VCS.Status;

/**
 * Renderer for script tree.
 * 
 * Can display VCS local status on files.
 * 
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author$
 */
public class ScriptTreeCellRenderer extends DefaultTreeCellRenderer {

    /** serialVersionUID. */
    private static final long serialVersionUID = 807570061868454777L;

    /** Class logger. */
    private static Log log = LogFactory.getLog(ScriptTreeCellRenderer.class);
    
    /*
     * @see javax.swing.tree.TreeCellRenderer#getTreeCellRendererComponent(javax.swing.JTree, java.lang.Object, boolean, boolean, boolean, int, boolean)
     */
    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value,
            boolean selected, boolean expanded, boolean leaf, int row,
            boolean hasFocus) {

        JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        
        if (value instanceof File) {
            File file = (File)value;
            
            try {
                if (file.isFile()) {
                    if (IsisFish.vcs.getLocalStatus(file) == Status.STATUS_MODIFIED) {
                        if (selected) {
                            c.setForeground(new Color(188, 188, 255));
                        }
                        else {
                            c.setForeground(Color.BLUE);
                        }
                    }
                    else if (IsisFish.vcs.getLocalStatus(file) == Status.STATUS_ADDED) {
                        if (selected) {
                            c.setForeground(Color.GREEN.brighter());
                        }
                        else {
                            c.setForeground(Color.GREEN.darker());
                        }
                    }
                }
            } catch (VCSException e) {
                if (log.isErrorEnabled()) {
                    log.error("Can't get file status", e);
                }
            }
            c.setText(file.getName());
        }

        return c;
    }
}
