/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2009 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.script.action;

import static org.nuiton.i18n.I18n._;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ZipUtil;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.ui.script.FileSelectionTableModel;
import fr.ifremer.isisfish.ui.util.IsisAction;

/**
 * Action to export a set of selected file to a zip archive.
 * 
 * @author chatellier
 * @version $Revision$
 * 
 * Last update : $Date$
 * By : $Author$
 * 
 * @deprecated C'est pas evident de faire des Actions swing avec jaxx
 */
public class ExportAction extends IsisAction {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3373564473968724365L;

    /** log. */
    private static Log log = LogFactory.getLog(ExportAction.class);

    protected FileSelectionTableModel model;

    protected JTextField file;

    protected File root;

    private List<String> selected;

    private File dst;

    /**
     * Export action constructor.
     * 
     * @param dialog dialog ???
     * @param file textfield containing dest archive path
     * @param root root for all file in includes that is in this directory
     * @param model selected file model
     */
    public ExportAction(JDialog dialog, JTextField file, File root,
            FileSelectionTableModel model) {
        super(dialog);
        this.file = file;
        this.root = root;
        this.model = model;
    }

    @Override
    protected boolean prepare() {
        dst = new File(file.getText());

        if ("".equals(dst.getAbsolutePath())) {
            return false;
        }

        if (dst.exists()) {
            int resp = JOptionPane.showConfirmDialog(dialog,
                    _("isisfish.message.file.already.exists", dst));

            if (resp == JOptionPane.CANCEL_OPTION) {
                dialog.dispose();
                return false;
            }
            if (resp == JOptionPane.YES_OPTION) {
                dst.getParentFile().mkdirs();
            } else {
                return false;
            }
        } else if (!dst.getParentFile().exists()) {
            int resp = JOptionPane.showConfirmDialog(dialog,
                    _("isisfish.message.directory.not.exists", dst));
            if (resp == JOptionPane.CANCEL_OPTION) {
                dialog.dispose();
                return false;
            }
            if (resp == JOptionPane.YES_OPTION) {
                dst.getParentFile().mkdirs();
            } else {
                return false;
            }
        }

        selected = model.getSelectedFiles();

        return !(selected == null || selected.isEmpty());
    }

    @Override
    protected void perform(ActionEvent e) {
        try {

            List<File> toZip = new ArrayList<File>();

            for (String path : selected) {
                toZip.add(new File(root, path));
            }

            if (dst.exists()) {
                dst.delete();
            }

            dst.createNewFile();

            ZipUtil.compressFiles(dst, root, toZip);

            if (log.isInfoEnabled()) {
                log.info("Zip DataStorage in " + dst + "[" + toZip.size()
                        + " files] (size " + dst.length() + ")");
            }

        } catch (IOException e1) {
            throw new IsisFishRuntimeException(e1);
        }
    }
}