/*
 * #%L
 * IsisFish
 * 
 * $Id: SimpleResultatMapBean.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.result;

import static org.nuiton.i18n.I18n._;

import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.gui.Tool;

import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.ResultatLayer;

/**
 * SimpleResultatMapBean.java
 *
 *
 * Created: Fri Jun  7 13:02:18 2002
 *
 * @author <a href="mailto:seb.regnier@free.fr"></a>
 * @version
 */
public class SimpleResultatMapBean extends SimpleResultatMapBeanUI {
    public SimpleResultatMapBean (){
        super();
        init();
        initBean();
    }

    protected void initBean(){
        // Create the directional and zoom control tool
        OMToolSet resultatMapOMTS = new OMToolSet();

        // Associate the tool with the map
        resultatMapOMTS.setupListeners(getIsisMapBean());

        // Add the tool to the map toolbar
        getIsisMapBeanToolBar().add((Tool)resultatMapOMTS);

        getInformationDelegator().setMap(getIsisMapBean());
        getInformationDelegator().setShowLights(false);
        getInformationDelegator().setLabel(_("isisfish.simpleResult.more.information"));
    }

    public void addResultatLayer(String id, ResultatLayer layer) {
        getIsisMapBean().addResultatLayer(id, layer);
        getLegendPanel().setModel(new LegendModel(0,Math.round(layer.getDataMapList().getMaxDataMapValue())));
        // poussin 20060822 FIXME: migration vers v3, je ne sais pas comment ca merchait avant, la methode n'existe pas :(
//        getInformationDelegator().addLayer(layer);
    }

    public void removeAllResultatLayer() {
        getIsisMapBean().removeAllResultatLayer();
    }

    public void setRegion(FisheryRegion region) {
        getIsisMapBean().setFisheryRegion(region);
    }

}// SimpleResultatMapBean
