/*
 * #%L
 * IsisFish
 * 
 * $Id: ResultView.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.result;

/**
* ResultView.java
*
*
* Created: Thu May 30 15:48:00 2002
*
* @author <a href="mailto:seb.regnier@free.fr"></a>
* @version
*/

import static org.nuiton.i18n.I18n._;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.logging.SimulationLoggerUtil;
import fr.ifremer.isisfish.simulator.SimulationProperties;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import fr.ifremer.isisfish.ui.widget.filter.FilterModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ItemEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;

public class ResultView extends ResultViewUI {

    /** to use log facility, just put in your code: log.info("..."); */
    static private Log log = LogFactory.getLog(ResultView.class);
    private FilterModel<SimulationProperties, String> filterModel;
    private DefaultComboBoxModel model;

    /*
     * FIXME this code reload ALL simulation (too long)
     */
    SimulationServiceListener listener = new SimulationServiceListener() {

            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }

            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                try {
                    initSimulation();
                } catch (IOException ex) {
                    log.error(ex);
                } catch (ParseException ex) {
                    log.error(ex);
                }
            }

            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };

    public ResultView (){
        super();
        SimulationService.getService().addSimulationServiceListener(listener);
        init();
        try {
            initSimulation();
        } catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn(_("could not create simulation filter model for reason %1$s", e.getMessage()),e);
            }
            ErrorHelper.showErrorDialog(_("could not create simulation filter model for reason %1$s", e.getMessage()), e);
        }
    }

    private void initSimulation() throws IOException, ParseException {
        // keep in context list of old simulation names (for filter process)
        java.util.List<String> value = SimulationStorage.getSimulationNames();

        // TODO filering disabled since it's read all simulation
        // TODO can take more than 20m with a lot of simulations...
        
        // create filter model
        //filterModel = SimulationFilterUtil.createFilterModel(value);
        // to used directly model.getFilteredResult() in xml
        // we must fill filterModel result with original items
        //filterModel.selectAll();
        
        getSimulation().setEditable(false);
        model = new DefaultComboBoxModel(value.toArray());
        getSimulation().setModel(model);
        getSimulation().setSelectedItem(null);
    }

    public void on_Resultat_destroy_event(){
//        dispose();
    }

    public void on_simulation_selection_notify_event(ItemEvent e){
        //	setSelectedSimulation((Simulation)getSimulation().getSelectedItem());
    }

    /*
    * Get the value of selectedSimulation.
    * @return value of selectedSimulation.
    *
    public Simulation getSelectedSimulation() {
        return selectedSimulation;
    }*/

    /*
    * Set the value of selectedSimulation.
    * @param v  Value to assign to selectedSimulation.
    *
    public void setSelectedSimulation(Simulation v) {
        this.selectedSimulation = v;
    }*/

    public void on_supprimerSimulationButton_clicked(){
        String name = (String)getSimulation().getSelectedItem();
        if (name != null){
            SimulationStorage storage = SimulationStorage.getSimulation(name);
            try {
                storage.delete(false);
                initSimulation();
            } catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Can't delete simulation", eee);
                }
                ErrorHelper.showErrorDialog(_("Can't delete simulation"), eee);
            }
        }
    }

    public void on_openWindowButton_clicked(){
        String name = (String)getSimulation().getSelectedItem();
        if (name != null){
            SimulationStorage simulation = SimulationStorage.getSimulation(name);

            ResultEdit resEdit = new ResultEdit(simulation);
            JInternalFrame intFrame =
                new JInternalFrame(simulation.getName(),
                        true, //resizable
                        true, //closable
                        true, //maximizable
                        true);//iconifiable
            intFrame.setContentPane(resEdit.getRootPane());
            intFrame.setVisible(true);
            //	    intFrame.pack();
            intFrame.setSize(new Dimension(800,700));
            getDesktopPane().add(intFrame);
            try {
                intFrame.setSelected(true);
            } catch (PropertyVetoException eee) {
                if (log.isWarnEnabled()) {
                    log.warn("Error dans l internalFrame ", eee);
                }
                ErrorHelper.showErrorDialog(_("Can't open simulation internal frame"), eee);
            }
        }
    }

    public void on_voirSimulationLogButton_clicked() {
        String name = (String)getSimulation().getSelectedItem();

        try {
            SimulationLoggerUtil.showSimulationLogConsole(name);

        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(_("Can't display simulation log"), e);
            }
            ErrorHelper.showErrorDialog(_("Can't display simulation log"), e);
        }
    }
    public void on_filterSimulationLogButton_clicked() {

        try {
            List<String> result = SimulationFilterUtil.filterSimulation(filterModel);

            model.removeAllElements();
            for (String s : result) {
                model.addElement(s);
            }
        } catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn(_("could not filter on simulations"), e);
            }
            ErrorHelper.showErrorDialog(_("could not filter on simulations"), e);
        }
    }

}// ResultView
