/*
 * #%L
 * IsisFish
 * 
 * $Id: InfoItemDateListRenderer.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.result;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import fr.ifremer.isisfish.types.Date;

/**
 * InfoItemDateListRenderer.
 *
 * Created: Thu Sep 12 20:16:20 2002
 *
 * @author <a href="mailto:seb.regnier@free.fr"></a>
 * @version $Revision: 3124 $
 */
public class InfoItemDateListRenderer extends DefaultListCellRenderer {
    
    /** serialVersionUID */
    private static final long serialVersionUID = -3340579108147857972L;

    public InfoItemDateListRenderer (){
	super();
    }
    
    public Component getListCellRendererComponent(JList liste,
						  Object o,
						  int attributeIndex,
						  boolean isSelected,
						  boolean hasFocus){
	super.getListCellRendererComponent(liste, o, attributeIndex,isSelected, hasFocus);
	if (o instanceof Date)
	    setText((o == null) ? "" : ((Date)o).getMonth().toString()+" "+((Date)o).getYear());
	else
	    setText((o == null) ? "" : o.toString());
	return this;
    }
}// InfoItemDateListRenderer
