/*
 * #%L
 * IsisFish
 * 
 * $Id: DataResult.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2002 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.result;

import java.io.File;
import java.io.FileWriter;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.util.FileUtil;

/**
 * Objet permettant l'affichage des donnees resultats sous forme de
 * matrice.
 */
public class DataResult extends DataResultUI { // IfremerSimulation

    /** serialVersionUID. */
    private static final long serialVersionUID = -4089377865270062094L;

    /** Class logger. */
    private static Log log = LogFactory.getLog(DataResult.class);

    protected MatrixND matrix;

    public DataResult() {
        super();
        init();
    }

    public MatrixND getMatrix() {
        return matrix;
    }

    public void setMatrix(MatrixND  v) {
        this.matrix = v;
        reload();
    }

    public void reload(){
        loadDescription();
        loadMatrice();
    }

    /**
    * Affiche le titre de la matrice
    */
    public void loadDescription(){
        getDescriptionLabel().setText(getMatrix().getName());
    }

    /**
    * Affiche la matrice dans le panel de matrice
    */
    public void loadMatrice(){
        // TODO remplacer la table specifique comme expliqué dans le FIXME
        // pour l'affichage des data
        // par le panel des matrix qui fait la meme chose
        // Il faut juste ajouter que si la matrice a 2 dimensions
        // le coin en haut a gauche affiche l'intitulé des dimension
        // par exemple 'date/population'

//        getMatrixPanel().setMatrice(getMatrix());
        // FIXME si le composant ou dessus fonctionne, supprimer la ligne
        // suivante et sans doute aussi le MatrixInfoTableModel.
        getMatriceTable().setModel(new MatrixInfoTableModel(getMatrix()));

    }

    public void on_exportButton_clicked(){
        String result = getMatrix().getName() + ";";
        try{
            File file = FileUtil.getFile(".+.csv", "CSV file");
            if(file != null){
                for (Iterator i=getMatrix().getSemantics(1).iterator();
                i.hasNext();){

                    result += i.next().toString();
                    if(i.hasNext()){
                        result += ";";
                    }else{
                        result += "\n";
                    }
                }

                int y=0;
                for (Iterator i=getMatrix().getSemantics(0).iterator();
                i.hasNext(); y++){
                    result += i.next().toString()+";";
                    for(int x=0; x<getMatrix().getDim(1); x++){
                        result += getMatrix().getValue(y, x) + ";";
                    }
                    result += "\n";
                }

                FileWriter writer = new FileWriter(file);
                writer.write(result);
                writer.close();
            }
        }catch(Exception eee){
            log.error(":104:Error during export"+eee);
        }
    }

}

