/*
 * #%L
 * IsisFish
 * 
 * $Id: SensitivityExportParametersTableCellEditor.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.sensitivityexport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor;

/**
 * Specific editor for export parameters.
 *
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class SensitivityExportParametersTableCellEditor extends ParameterTableCellEditor {

    /** serialVersionUID. */
    private static final long serialVersionUID = 8211639776194497615L;

    protected SensitivityExport export;

    protected List<Class<?>> exportParametersTypes;

    /**
     * Constructor with export parameter.
     * 
     * @param export export
     */
    public SensitivityExportParametersTableCellEditor(SensitivityExport export) {
        super();

        this.export = export;
        exportParametersTypes = new ArrayList<Class<?>>();
        //TODO map may be sorted
        Map<String, Class<?>> planParametersNamesAndTypes = SensitivityExportStorage
                .getParameterNames(export);
        for (Class<?> type : planParametersNamesAndTypes.values()) {
            exportParametersTypes.add(type);
        }
    }

    /*
     * @see fr.ifremer.isisfish.ui.widget.editor.ParameterTableCellEditor#getType(java.lang.Object, int, int)
     */
    @Override
    protected Class<?> getType(Object value, int row, int column) {
        return exportParametersTypes.get(row);
    }
}
