/*
 * #%L
 * IsisFish
 * 
 * $Id: SensitivityCalculatorListModel.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.sensitivity;

import java.util.List;

import javax.swing.AbstractListModel;

import fr.ifremer.isisfish.simulator.sensitivity.SensitivityCalculator;

/**
 * Model pour la liste des instances de calculateurs.
 *
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class SensitivityCalculatorListModel extends AbstractListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    protected List<SensitivityCalculator> sensitivityCalculators;

    /**
     * Empty constructor.
     */
    public SensitivityCalculatorListModel() {
        this(null);
    }

    /**
     * Constructor with list.
     * 
     * @param sensitivityCalculators calculators
     */
    public SensitivityCalculatorListModel(List<SensitivityCalculator> sensitivityCalculators) {
        super();
        setSensitivityCalculators(sensitivityCalculators);
    }

    /**
     * Get calculators list.
     * 
     * @return the calculators
     */
    public List<SensitivityCalculator> getSensitivityCalculators() {
        return sensitivityCalculators;
    }

    /**
     * Set calculators list.
     * 
     * @param sensitivityCalculators the calculators to set
     */
    public void setSensitivityCalculators(List<SensitivityCalculator> sensitivityCalculators) {
        this.sensitivityCalculators = sensitivityCalculators;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return sensitivityCalculators.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (sensitivityCalculators != null) {
            size = sensitivityCalculators.size();
        }
        return size;
    }
}
