/*
 * #%L
 * IsisFish
 * 
 * $Id: ExportNameListModel.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.export;

import java.util.List;

import javax.swing.DefaultListModel;

/**
 * Model pour la liste des noms d'exports.
 *
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author: chatellier $
 */
public class ExportNameListModel extends DefaultListModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** Analyze plan names. */
    protected List<String> exportNames;

    /**
     * Empty constructor.
     */
    public ExportNameListModel() {
        this(null);
    }

    /**
     * Constructor with export list.
     * 
     * @param exportNames exports Names
     */
    public ExportNameListModel(List<String> exportNames) {
        super();
        setExportNames(exportNames);
    }

    /**
     * Get exports names.
     * 
     * @return the analyze plan names
     */
    public List<String> getExportNames() {
        return exportNames;
    }

    /**
     * Set analyze plan names.
     * 
     * @param exportNames the exports names to set
     */
    public void setExportNames(List<String> exportNames) {
        this.exportNames = exportNames;
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return exportNames.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (exportNames != null) {
            size = exportNames.size();
        }
        return size;
    }
}
