/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.population;

import java.util.List;

import javax.swing.DefaultComboBoxModel;

import fr.ifremer.isisfish.entities.PopulationSeasonInfo;

/**
 * Model pour la liste des {@link PopulationSeasonInfo}.
 *
 * @author chatellier
 * @version $Revision: 2350 $
 * 
 * Last update : $Date: 2009-06-09 13:52:58 +0200 (mar. 09 juin 2009) $
 * By : $Author: chatellier $
 */
public class PopulationSeasonInfoComboModel extends DefaultComboBoxModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6171850179969290032L;

    /** PopulationSeasonInfo list */
    protected List<PopulationSeasonInfo> populationSeasonInfos;

    /**
     * Empty constructor.
     */
    public PopulationSeasonInfoComboModel() {
        this(null);
    }

    /**
     * Constructor with population season info list.
     * 
     * @param populationSeasonInfos population season info list
     */
    public PopulationSeasonInfoComboModel(List<PopulationSeasonInfo> populationSeasonInfos) {
        super();
        setPopulationSeasonInfos(populationSeasonInfos);
    }

    /**
     * Get population season info list.
     * 
     * @return population season info list
     */
    public List<PopulationSeasonInfo> getPopulationSeasonInfos() {
        return populationSeasonInfos;
    }

    /**
     * Set population season info list.
     * 
     * @param populationSeasonInfos the population season info list to set
     */
    public void setPopulationSeasonInfos(List<PopulationSeasonInfo> populationSeasonInfos) {
        this.populationSeasonInfos = populationSeasonInfos;
        
        // clear selection
        setSelectedItem(null);
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public Object getElementAt(int index) {
        return populationSeasonInfos.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (populationSeasonInfos != null) {
            size = populationSeasonInfos.size();
        }
        return size;
    }
}
