/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.StrategyMonthInfoImpl;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyImpl;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import jaxx.runtime.swing.editor.NumberEditor;
import fr.ifremer.isisfish.entities.TripType;

public class StrategyOneMonthInfoUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS09TQRQeKm9EeUlYgCASH1FvFYwPICqCxJJWiEBC7MZp77QdcjszzsyFWxfGxK0xrFy4Ufcu3Rvj0pVb/4Mx/gPP3Nun3JQb28V9nPudb75v5pzTT79Qh5LozC72PEu6TNMisdaWdnbWM7skq1eIykoqNJco+LXFUCyN+uxqXGl0Np006fFyenyZFwVnhNVlLyRRr9Ilh6gCIVqjU0FGVqn4ZjW84AlXVtiqYsLYPvz5HTuwX36MIeQJUNUPFqaOyqo5aE+iGLU1GoKV9nDcwSwPMiRledDZb2LLDlbqES6SZ+gF6kqiToElkGk0Hd2qz+Hne0KjgZkEE65e5kwDfDtxVaO5nLRoTpIigbuiKkdVwXKpRQ3QAkFYk3xpnZEUJBUSLMe3E0L4lJ0gXgUAGnzeIh7IGzDiLWPICgzV8O0ZgplGF8MWBUVUU6KqiyaKwqmlDpaXKlWFaDQbiaea0Eg4PLPp71aCARw79DmR1zSa9E8wC1tKHWA9BKn3wu2SRmMNR672wa+1hTMOqSG7Z9aSOEOcWdgwszdeGRZEDWisij2do8SxD0nfAhlbJUEqAhvXM70CVZDh97nXSFdZes68TzR+62duMUPkes6QqxBAJfl6yLfz4TpTlCUYzmq6R3VpBZegM0cbLJsSWTWpjXRT4XQbkgsuNYV3dJnLvMVcqjmzilgXzEVSz8pDtab8xw3MiPPABoQss0s0HJynMuVQ6fFaE7alUYd0IQxVm66Ng8cQCgZBOeoT+NH3r97tvf38Zb7S9QOwRn8DpG5IQRcKcECkqUeNTgat7mrqxFNYLKRRjyIOTDh/go3UCdgsh0EE8A/6DWXSrIdYFSC1o+vn12+jT38cQ7FV1OtwbK9ig0+gHl2Q4JI7tifu3vOVHN/vNkKNJo26CDPFCYPnxKKNNZ7KUGbDydzxwO1InduqhO8Hr1PjbyZuVhy3BYr+gdVcdzxBnZQ5lBF/wpWHV+hE6xOKuDavDamwsdVm7uOi3E6z/vVGmLW+HJTJlX1C8wWYQkOLgYgprKE2Mq4mYNHkzvsezNNiZOp2DWVrvt7+Xw4TvtWEYbJlhulIDKvmstQKQzMNM9E1tMTQTMO5lvchGkMzDRda3odoDM00XIrSMqZDsExxO/gfaoFqtI5qs8D3V0gOu06zponC2hkM+SNY/gI/vwJgQQoAAA==";
    protected fr.ifremer.isisfish.entities.StrategyImpl bean;
    protected javax.swing.JTextField fieldStrategyMonthInfoMinInactivityDays;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor fieldStrategyMonthInfoProportion;
    protected jaxx.runtime.swing.JAXXComboBox fieldStrategyMonthInfoTripType;
    protected javax.swing.JLabel numberOfTrips;
    protected java.lang.String strategieMonthText;
    protected fr.ifremer.isisfish.entities.StrategyMonthInfoImpl strategyMonthInfo;
    private fr.ifremer.isisfish.ui.input.StrategyOneMonthInfoUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "numberOfTrips.text");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyMonthInfoMinInactivityDays.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyMonthInfoMinInactivityDays.text");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyMonthInfoProportion.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyMonthInfoProportion.matrix");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.text");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyMonthInfoTripType.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "numberOfTrips.enabled");

    /* begin raw body code */
    protected int month;
    
    
    protected void strategyMonthInfoProportionMatrixChanged(MatrixPanelEvent event) {
        if (getStrategyMonthInfo() != null && fieldStrategyMonthInfoProportion.getMatrix() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Matrix modified : " + fieldStrategyMonthInfoProportion.getMatrix());
            }
            getStrategyMonthInfo().setProportionMetier(fieldStrategyMonthInfoProportion.getMatrix().copy());
        }
    }
    
    @Override
    public void refresh() {
        Strategy strategy = (Strategy)getVerifier().getEntity(Strategy.class);
        
        // don't use setBean(null) here
        setBean((StrategyImpl)strategy);
    
        if (getBean() != null) {
            Object[] monthInfos = getBean().getStrategyMonthInfo().toArray();
            if (monthInfos.length != 0) {
            
                // add null before, for second to be considered as a changed event
                // otherwize, setBean has no effect
                setStrategyMonthInfo(null);
                setStrategyMonthInfo((StrategyMonthInfoImpl) monthInfos[month]);
                getVerifier().addCurrentEntity(getStrategyMonthInfo());
                
                if (getStrategyMonthInfo() != null) {
                    numberOfTrips.putClientProperty("beanID", getStrategyMonthInfo().getTopiaId());
                    fieldStrategyMonthInfoProportion.putClientProperty("beanID", getStrategyMonthInfo().getTopiaId());
                    fieldStrategyMonthInfoMinInactivityDays.putClientProperty("beanID", getStrategyMonthInfo().getTopiaId());
                    ActionListener[] listeners = fieldStrategyMonthInfoTripType.getActionListeners();
                    for (ActionListener listener : listeners) {
                        fieldStrategyMonthInfoTripType.removeActionListener(listener);
                    }
                    jaxx.runtime.SwingUtil.fillComboBox(fieldStrategyMonthInfoTripType,getRegion().getTripType(), getStrategyMonthInfo().getTripType(), true);
                    for (ActionListener listener : listeners) {
                        fieldStrategyMonthInfoTripType.addActionListener(listener);
                    }
                    setProportionMetierMatrix();
                }
                else {
                    // don't put in addPropertyChangeListener
                    // if called after, remove content :(
                    numberOfTrips.setText("");
                    fieldStrategyMonthInfoMinInactivityDays.setText("");
                    fieldStrategyMonthInfoProportion.setMatrix(null);
                }
            }
        }
        //fieldStrategyMonthInfoProportion.addMatrixListener(matrixListener);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    public void init(int m) {
        jaxx.runtime.Util.assignment(month = m, "month", fr.ifremer.isisfish.ui.input.StrategyOneMonthInfoUI.this);
    }
    
    protected void setProportionMetierMatrix() {
        if (getStrategyMonthInfo().getProportionMetier() != null) {
            fieldStrategyMonthInfoProportion.setMatrix(getStrategyMonthInfo().getProportionMetier().copy());
        }
        else {
            fieldStrategyMonthInfoProportion.setMatrix(null);
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public StrategyOneMonthInfoUI() {
        super();
        $initialize();
    }

    public StrategyOneMonthInfoUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("$JLabel2.text".equals($binding)) {
                addPropertyChangeListener("strategieMonthText", $DataSource6);
        
        } else if ("fieldStrategyMonthInfoTripType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource7);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("numberOfTrips.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("numberOfTrips.text".equals($binding)) {
                addPropertyChangeListener("strategyMonthInfo", $DataSource10);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().addPropertyChangeListener("numberOfTrips", $DataSource10);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldStrategyMonthInfoMinInactivityDays.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldStrategyMonthInfoMinInactivityDays.text".equals($binding)) {
                addPropertyChangeListener("strategyMonthInfo", $DataSource13);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().addPropertyChangeListener("minInactivityDays", $DataSource13);
            }
        } else if ("fieldStrategyMonthInfoProportion.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldStrategyMonthInfoProportion.matrix".equals($binding)) {
                addPropertyChangeListener("strategyMonthInfo", $DataSource17);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().addPropertyChangeListener("proportionMetier", $DataSource17);
            }if ( getStrategyMonthInfo() != null) {
                 getStrategyMonthInfo().addPropertyChangeListener("proportionMetier", $DataSource17);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("$JLabel2.text".equals($dest)) {
            $JLabel2.setText(_(String.valueOf((getStrategieMonthText()))));
            } else if ("fieldStrategyMonthInfoTripType.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyMonthInfoTripType.setEnabled((isActif()));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("numberOfTrips.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                numberOfTrips.setEnabled((isActif()));
            }
            } else if ("numberOfTrips.text".equals($dest)) {
            if (getStrategyMonthInfo() != null) {
                numberOfTrips.setText(_(String.valueOf((getStrategyMonthInfo().getNumberOfTrips()))));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldStrategyMonthInfoMinInactivityDays.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyMonthInfoMinInactivityDays.setEnabled((isActif()));
            }
            } else if ("fieldStrategyMonthInfoMinInactivityDays.text".equals($dest)) {
            if (getStrategyMonthInfo() != null) {
                jaxx.runtime.SwingUtil.setText(fieldStrategyMonthInfoMinInactivityDays, String.valueOf((getStrategyMonthInfo().getMinInactivityDays())));
            }
            } else if ("fieldStrategyMonthInfoProportion.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyMonthInfoProportion.setEnabled((isActif()));
            }
            } else if ("fieldStrategyMonthInfoProportion.matrix".equals($dest)) {
            if ( getStrategyMonthInfo() != null) {
                fieldStrategyMonthInfoProportion.setMatrix((getStrategyMonthInfo().getProportionMetier() == null ? null : getStrategyMonthInfo().getProportionMetier().copy()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("$JLabel2.text".equals($binding)) {
                removePropertyChangeListener("strategieMonthText", $DataSource6);
        
        } else if ("fieldStrategyMonthInfoTripType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource7);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("numberOfTrips.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("numberOfTrips.text".equals($binding)) {
                removePropertyChangeListener("strategyMonthInfo", $DataSource10);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().removePropertyChangeListener("numberOfTrips", $DataSource10);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldStrategyMonthInfoMinInactivityDays.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldStrategyMonthInfoMinInactivityDays.text".equals($binding)) {
                removePropertyChangeListener("strategyMonthInfo", $DataSource13);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().removePropertyChangeListener("minInactivityDays", $DataSource13);
            }
        } else if ("fieldStrategyMonthInfoProportion.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldStrategyMonthInfoProportion.matrix".equals($binding)) {
                removePropertyChangeListener("strategyMonthInfo", $DataSource17);
        if (getStrategyMonthInfo() != null) {
                getStrategyMonthInfo().removePropertyChangeListener("proportionMetier", $DataSource17);
            }if ( getStrategyMonthInfo() != null) {
                 getStrategyMonthInfo().removePropertyChangeListener("proportionMetier", $DataSource17);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldStrategyMonthInfoTripType(java.awt.event.ActionEvent event) {
        getStrategyMonthInfo().setTripType((TripType)fieldStrategyMonthInfoTripType.getSelectedItem());
    }

    public void doKeyReleased__on__fieldStrategyMonthInfoMinInactivityDays(java.awt.event.KeyEvent event) {
        getStrategyMonthInfo().setMinInactivityDays(Double.parseDouble(fieldStrategyMonthInfoMinInactivityDays.getText()));
    }

    public void doMatrixChanged__on__fieldStrategyMonthInfoProportion(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        strategyMonthInfoProportionMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.StrategyImpl getBean() {
        return bean;
    }

    public javax.swing.JTextField getFieldStrategyMonthInfoMinInactivityDays() {
        return fieldStrategyMonthInfoMinInactivityDays;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getFieldStrategyMonthInfoProportion() {
        return fieldStrategyMonthInfoProportion;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldStrategyMonthInfoTripType() {
        return fieldStrategyMonthInfoTripType;
    }

    public javax.swing.JLabel getNumberOfTrips() {
        return numberOfTrips;
    }

    public java.lang.String getStrategieMonthText() {
        return strategieMonthText;
    }

    public fr.ifremer.isisfish.entities.StrategyMonthInfoImpl getStrategyMonthInfo() {
        return strategyMonthInfo;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.StrategyImpl newValue) {
        fr.ifremer.isisfish.entities.StrategyImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setStrategieMonthText(java.lang.String newValue) {
        java.lang.String oldValue = this.strategieMonthText;
        this.strategieMonthText = newValue;
        firePropertyChange("strategieMonthText", oldValue, newValue);
    }

    public void setStrategyMonthInfo(fr.ifremer.isisfish.entities.StrategyMonthInfoImpl newValue) {
        fr.ifremer.isisfish.entities.StrategyMonthInfoImpl oldValue = this.strategyMonthInfo;
        this.strategyMonthInfo = newValue;
        firePropertyChange("strategyMonthInfo", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.StrategyOneMonthInfoUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        addChildrenToBody();
        
        
        addChildrenToNumberOfTrips();
        
        addChildrenToFieldStrategyMonthInfoMinInactivityDays();
        addChildrenToFieldStrategyMonthInfoProportion();
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("$JLabel2.text");
        applyDataBinding("fieldStrategyMonthInfoTripType.enabled");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("numberOfTrips.enabled");
        applyDataBinding("numberOfTrips.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldStrategyMonthInfoMinInactivityDays.enabled");
        applyDataBinding("fieldStrategyMonthInfoMinInactivityDays.text");
        applyDataBinding("fieldStrategyMonthInfoProportion.enabled");
        fieldStrategyMonthInfoProportion.setLinearModel((true));
        fieldStrategyMonthInfoProportion.setLinearModelShowDefault((true));
        applyDataBinding("fieldStrategyMonthInfoProportion.matrix");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createStrategieMonthText();
        createBean();
        createStrategyMonthInfo();
        
        month = 0;
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        if ($JLabel2.getFont() != null) $JLabel2.setFont($JLabel2.getFont().deriveFont($JLabel2.getFont().getStyle() | Font.BOLD));
        
        createFieldStrategyMonthInfoTripType();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.strategyMonthInfo.numberOfTrips"));
        
        createNumberOfTrips();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.strategyMonthInfo.minInactivityDays"));
        
        createFieldStrategyMonthInfoMinInactivityDays();
        createFieldStrategyMonthInfoProportion();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JLabel2, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyMonthInfoTripType), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(numberOfTrips), new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel4, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyMonthInfoMinInactivityDays), new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyMonthInfoProportion), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldStrategyMonthInfoMinInactivityDays() {
        if (!allComponentsCreated) {
            return;
        }
        fieldStrategyMonthInfoMinInactivityDays.putClientProperty("bean", fr.ifremer.isisfish.entities.StrategyMonthInfoImpl.class);
        fieldStrategyMonthInfoMinInactivityDays.putClientProperty("method", "MinInactivityDays");
    }

    protected void addChildrenToFieldStrategyMonthInfoProportion() {
        if (!allComponentsCreated) {
            return;
        }
        fieldStrategyMonthInfoProportion.putClientProperty("bean", fr.ifremer.isisfish.entities.StrategyMonthInfoImpl.class);
        fieldStrategyMonthInfoProportion.putClientProperty("method", "ProportionMetier");
    }

    protected void addChildrenToNumberOfTrips() {
        if (!allComponentsCreated) {
            return;
        }
        numberOfTrips.putClientProperty("bean", fr.ifremer.isisfish.entities.StrategyMonthInfoImpl.class);
        numberOfTrips.putClientProperty("method", "NumberOfTrips");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createFieldStrategyMonthInfoMinInactivityDays() {
        fieldStrategyMonthInfoMinInactivityDays = new javax.swing.JTextField();
        $objectMap.put("fieldStrategyMonthInfoMinInactivityDays", fieldStrategyMonthInfoMinInactivityDays);
        fieldStrategyMonthInfoMinInactivityDays.setName("fieldStrategyMonthInfoMinInactivityDays");
        fieldStrategyMonthInfoMinInactivityDays.setColumns(15);
        fieldStrategyMonthInfoMinInactivityDays.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldStrategyMonthInfoMinInactivityDays"));
    }

    protected void createFieldStrategyMonthInfoProportion() {
        fieldStrategyMonthInfoProportion = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("fieldStrategyMonthInfoProportion", fieldStrategyMonthInfoProportion);
        fieldStrategyMonthInfoProportion.removeDataBinding("$MatrixEditor0.name");
        
        fieldStrategyMonthInfoProportion.setName("fieldStrategyMonthInfoProportion");
        fieldStrategyMonthInfoProportion.removeDataBinding("$MatrixEditor0.enabled");
        
        fieldStrategyMonthInfoProportion.removeDataBinding("$MatrixEditor0.linearModel");
        
        fieldStrategyMonthInfoProportion.removeDataBinding("$MatrixEditor0.linearModelShowDefault");
        
        fieldStrategyMonthInfoProportion.removeDataBinding("$MatrixEditor0.matrix");
        
        
        
        
        
        
        
        
        
        
        
        
        fieldStrategyMonthInfoProportion.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__fieldStrategyMonthInfoProportion"));
    }

    protected void createFieldStrategyMonthInfoTripType() {
        fieldStrategyMonthInfoTripType = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldStrategyMonthInfoTripType", fieldStrategyMonthInfoTripType);
        fieldStrategyMonthInfoTripType.setName("fieldStrategyMonthInfoTripType");
        fieldStrategyMonthInfoTripType.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldStrategyMonthInfoTripType"));
    }

    protected void createNumberOfTrips() {
        numberOfTrips = new javax.swing.JLabel();
        $objectMap.put("numberOfTrips", numberOfTrips);
        numberOfTrips.setName("numberOfTrips");
    }

    protected void createStrategieMonthText() {
        strategieMonthText = null;
        $objectMap.put("strategieMonthText", strategieMonthText);
    }

    protected void createStrategyMonthInfo() {
        strategyMonthInfo = null;
        $objectMap.put("strategyMonthInfo", strategyMonthInfo);
    }

}
