/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.Selectivity;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.ui.input.gear.GearPopulationSelectivityModel;
import fr.ifremer.isisfish.ui.input.gear.PopulationComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;

public class SelectivityEditorUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRQeKuU3gvwQNRARa2JisgWNQYUIgqAlRYyVxNiL0+6UDpnuDDOzsHAwJl6N4eTBi3r36N0Yj568+j8Y43/gm92y29VaG9vDbvP2fd9833vz3vvvKKkkOreNPc+SrqNphVhrtx492ihsk6K+TVRRUqG5RMGvLYESedRrh3Gl0fl81sDTVXh6mVcEd4hTg57Loh6l9xlRZUK0RqMBoqhUOheG5zzhyiO2UEw9trc/fyQO7WfvEgh5AlT1gYXJf6EiB+1ZlKC2RkNw0i5OM+xsgQxJnS3Q2W9iywwrdQ9XyA56ijqzqENgCWQaTTVv1efw8Z7QaDCVcYSrl7mjIX0zM63RdElatCRJhcBbUVWiqmy51KIm0coRBg2gu1Tvr9gUiDczQvh8HRq1Fwh2NLpQjwHoqaZEWXcIlpmKYBGsR3DhMqwpqECXGoLvh5lxigkV6YpyArEEanrClM8yJbWWOGcgM8J2ph7iAiMzGp2KNUvtQekt/5vJ7A4BXam1LC4Qdhl6ZXi9amoQNUmjYe6ZEiXMztVTp9HZOueZWw79K/Al7sWphms8ruy4VY50w3b53d1wyFH+ZibOOYLtWnFLrtaGdDhmK4jGgf2ptVxRcsbuY4dc0Wgshog+xVGDNRb8wv5ewbDaqRAzBt74LvlDpfl8vkovjWIoJUyuFU1uNFpteZSULoRBQj4a8gcQCsa7GvUJ/Oib5693X334eONolo/DGf2xlJrVA7MlJBdEmjuq0UAwwK6mLL2OxVwedQe+/b00UiMgVw2DCOAPLqmBWXexKgM02fnt0+eTT74eQ4lV1MM4tlexyc+gbl2W4JIz2xMLi76Svr0ueA4aTXCpiWNKCVf/+LyNNZ4sUMeGEt/0wO1IjdtQwpfDF+vjLydmjxy3BYp+S4tcJx+jDuow6hB/b1VXUt091SsUcW0erZ56y6jNvE+L6lzO+M+r9ay1a+LBzhuaD06fxBqWZMHVBLwZ0HVfvPk31ySnCc+ax7X6DONNqEpCY2ipAcnZZqyZBdoiR7LI8MFBiyQDJS4rcMmXsSZbXO6bxMX/pTPhhZYZGjVoqmUNzTE00nCxibJ2S753l9Ctsm4g5d9EoZS/MFxquRyG4RfOmogUhQkAAA==";
    protected javax.swing.JButton addSelectivityButton;
    protected fr.ifremer.isisfish.entities.GearImpl bean;
    protected jaxx.runtime.swing.JAXXComboBox fieldSelectivityPopulation;
    protected fr.ifremer.isisfish.entities.PopulationImpl population;
    protected javax.swing.JButton removeSelectivityButton;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI selectivityEquation;
    protected java.lang.Boolean selectivityPopulationSelected;
    protected javax.swing.JTable selectivityTable;
    private fr.ifremer.isisfish.ui.input.SelectivityEditorUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane3;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "selectivityTable.enabled");
    private java.beans.PropertyChangeListener $DataSource4 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSelectivityPopulation.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "selectivityEquation.actif");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "selectivityEquation.bean");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "addSelectivityButton.enabled");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
    
        Gear gear = (Gear)getVerifier().getEntity(Gear.class);
    
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((GearImpl) gear);
    
        if (getBean() != null) {
            setSelectivityPopulationSelected(false);
            setSelectivityTableModel();
            fieldSelectivityPopulation.setModel(getSelectivityPopulationModel());
        }
        getVerifier().addCurrentPanel(selectivityEquation);
    
        // reset to false after addCurrentPanel refresh
        selectivityEquation.setActif(false);
    
        setSelectivityPopulationSelected(false);
        removeSelectivityButton.setEnabled(false);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    protected void setSelectivityTableModel() {
        
        java.util.List<Selectivity> selectivitiesList = new ArrayList<Selectivity>();
        
        // set model even if no selectivity
        // to clear data
        if (getBean().getPopulationSelectivity() != null){
            // move collection to list
            // and add all entity to verifier
            for (Selectivity oneSelectivity : getBean().getPopulationSelectivity()) {
                getVerifier().addCurrentEntity(oneSelectivity);
                selectivitiesList.add(oneSelectivity);
            }
        }
    
        // set table model
        GearPopulationSelectivityModel model = new GearPopulationSelectivityModel(selectivitiesList);
        selectivityTable.setModel(model);
        selectivityTable.setDefaultRenderer(Equation.class, model);
        selectivityTable.setDefaultEditor(Equation.class, new EquationTableEditor());
    }
    
    protected void addSelectivity() {
        getAction().addSelectivity((Population)getPopulation(), selectivityEquation.getEditor().getText(), getBean());
        setSelectivityTableModel();
    }
    
    protected void removeSelectivity() {
        GearPopulationSelectivityModel model = (GearPopulationSelectivityModel)selectivityTable.getModel();
        Selectivity selectedSelectivity = model.getSelectivities().get(selectivityTable.getSelectedRow());
        getAction().removeSelectivity(getBean(), selectedSelectivity);
        setSelectivityTableModel();
        removeSelectivityButton.setEnabled(false);
    }
    
    protected DefaultComboBoxModel getSelectivityPopulationModel() {
        java.util.List<Species> species = getRegion().getSpecies();
        java.util.List<Population> populations = new ArrayList<Population>();
        if (species != null) {
            for (Species s : species) {
                if (s.getPopulation() != null) {
                    populations.addAll(s.getPopulation());
                }
            }
        }
        PopulationComboModel selectivityPopulationModel = new PopulationComboModel(populations);
        return selectivityPopulationModel;
    }
    
    protected void selectivityChanged() {
        setSelectivityPopulationSelected(fieldSelectivityPopulation.getSelectedItem() != null);
        // FIXME remove Impl reference
        setPopulation((PopulationImpl)fieldSelectivityPopulation.getSelectedItem());
        addSelectivityButton.setEnabled(isSelectivityPopulationSelected());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SelectivityEditorUI() {
        super();
        $initialize();
    }

    public SelectivityEditorUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource4);
            }
        } else if ("fieldSelectivityPopulation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("selectivityEquation.actif".equals($binding)) {
                addPropertyChangeListener("selectivityPopulationSelected", $DataSource6);
        
        } else if ("selectivityEquation.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource7);
        
        } else if ("addSelectivityButton.enabled".equals($binding)) {
                addPropertyChangeListener("selectivityPopulationSelected", $DataSource9);
        
        } else if ("selectivityTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldSelectivityPopulation.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSelectivityPopulation.setEnabled((isActif()));
            }
            } else if ("selectivityEquation.actif".equals($dest)) {
            selectivityEquation.setActif((isSelectivityPopulationSelected()));
            } else if ("selectivityEquation.bean".equals($dest)) {
            selectivityEquation.setBean((getBean()));
            } else if ("addSelectivityButton.enabled".equals($dest)) {
            addSelectivityButton.setEnabled((isSelectivityPopulationSelected()));
            } else if ("selectivityTable.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                selectivityTable.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource4);
            }
        } else if ("fieldSelectivityPopulation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("selectivityEquation.actif".equals($binding)) {
                removePropertyChangeListener("selectivityPopulationSelected", $DataSource6);
        
        } else if ("selectivityEquation.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource7);
        
        } else if ("addSelectivityButton.enabled".equals($binding)) {
                removePropertyChangeListener("selectivityPopulationSelected", $DataSource9);
        
        } else if ("selectivityTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__addSelectivityButton(java.awt.event.ActionEvent event) {
        addSelectivity();
    }

    public void doActionPerformed__on__fieldSelectivityPopulation(java.awt.event.ActionEvent event) {
        selectivityChanged();
    }

    public void doActionPerformed__on__removeSelectivityButton(java.awt.event.ActionEvent event) {
        removeSelectivity();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAddSelectivityButton() {
        return addSelectivityButton;
    }

    public fr.ifremer.isisfish.entities.GearImpl getBean() {
        return bean;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldSelectivityPopulation() {
        return fieldSelectivityPopulation;
    }

    public fr.ifremer.isisfish.entities.PopulationImpl getPopulation() {
        return population;
    }

    public javax.swing.JButton getRemoveSelectivityButton() {
        return removeSelectivityButton;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getSelectivityEquation() {
        return selectivityEquation;
    }

    public java.lang.Boolean getSelectivityPopulationSelected() {
        return selectivityPopulationSelected;
    }

    public javax.swing.JTable getSelectivityTable() {
        return selectivityTable;
    }

    public java.lang.Boolean isSelectivityPopulationSelected() {
        return selectivityPopulationSelected !=null && selectivityPopulationSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.GearImpl newValue) {
        fr.ifremer.isisfish.entities.GearImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPopulation(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.population;
        this.population = newValue;
        firePropertyChange("population", oldValue, newValue);
    }

    public void setSelectivityPopulationSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectivityPopulationSelected;
        this.selectivityPopulationSelected = newValue;
        firePropertyChange("selectivityPopulationSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.SelectivityEditorUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer($JLabel2), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSelectivityPopulation), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(selectivityEquation), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(addSelectivityButton), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane3, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(removeSelectivityButton), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $JScrollPane3.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(selectivityTable));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldSelectivityPopulation.enabled");
        applyDataBinding("selectivityEquation.actif");
        applyDataBinding("selectivityEquation.bean");
        selectivityEquation.setClazz((fr.ifremer.isisfish.equation.SelectivityEquation.class));
        applyDataBinding("addSelectivityButton.enabled");
        applyDataBinding("selectivityTable.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopulation();
        createSelectivityPopulationSelected();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.selectivity.selectPopulation"));
        
        createFieldSelectivityPopulation();
        createSelectivityEquation();
        createAddSelectivityButton();
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createSelectivityTable();
        createRemoveSelectivityButton();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        selectivityTable.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                // le bouton ne doit pas s'activer dans l'analyse de sensibilite
                if (isActif()) {
                    removeSelectivityButton.setEnabled(selectivityTable.getSelectedRow() != -1);
                }
            }
        });
        $completeSetup();
    }

    protected void createAddSelectivityButton() {
        addSelectivityButton = new javax.swing.JButton();
        $objectMap.put("addSelectivityButton", addSelectivityButton);
        addSelectivityButton.setName("addSelectivityButton");
        addSelectivityButton.setText(_("isisfish.common.add"));
        addSelectivityButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__addSelectivityButton"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createFieldSelectivityPopulation() {
        fieldSelectivityPopulation = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldSelectivityPopulation", fieldSelectivityPopulation);
        fieldSelectivityPopulation.setName("fieldSelectivityPopulation");
        fieldSelectivityPopulation.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldSelectivityPopulation"));
    }

    protected void createPopulation() {
        population = null;
        $objectMap.put("population", population);
    }

    protected void createRemoveSelectivityButton() {
        removeSelectivityButton = new javax.swing.JButton();
        $objectMap.put("removeSelectivityButton", removeSelectivityButton);
        removeSelectivityButton.setName("removeSelectivityButton");
        removeSelectivityButton.setEnabled(false);
        removeSelectivityButton.setText(_("isisfish.common.remove"));
        removeSelectivityButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__removeSelectivityButton"));
    }

    protected void createSelectivityEquation() {
        selectivityEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("selectivityEquation", selectivityEquation);
        selectivityEquation.removeDataBinding("$InputContentUI0.name");
        
        selectivityEquation.setName("selectivityEquation");
        selectivityEquation.removeDataBinding("$InputContentUI0.actif");
        
        selectivityEquation.removeDataBinding("$InputContentUI0.bean");
        
        selectivityEquation.removeDataBinding("$InputContentUI0.clazz");
        
        selectivityEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        selectivityEquation.setFormuleCategory("Selectivity");
        selectivityEquation.removeDataBinding("$InputContentUI0.text");
        
        selectivityEquation.setText(_("isisfish.selectivity.equation"));
    }

    protected void createSelectivityPopulationSelected() {
        selectivityPopulationSelected = false;
        $objectMap.put("selectivityPopulationSelected", selectivityPopulationSelected);
    }

    protected void createSelectivityTable() {
        selectivityTable = new javax.swing.JTable();
        $objectMap.put("selectivityTable", selectivityTable);
        selectivityTable.setName("selectivityTable");
        selectivityTable.setRowHeight(24);
    }

}
