/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearImpl;

public class RangeOfValuesUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TS09TQRQ+LbQIiGJBolEjIj5izK2uTMT4wlRrihAehtiN094pHTK9d5w5Fy4ujIlbY1i5cKPuXbo3xqUrt/4HY/wHnpk+bitNsIuZm9PzffN95/HpF2SMhjObLI49HQUoGtx7eGd9fbGyyat4j5uqFgpDDc1fKg3pMoz6nbhBOFsuWXi+Bc/Phw0VBjzoQs+VYMTgjuSmzjkiHG0iqsbkVzrhuVhFus3WEdOP7cOf3+ld/+XHNECsSFWWLEzvh0ocDJYgLXyEHL20xfKSBRskQ4tgg3SO2di8ZMY8Yg3+DF7AUAmyimkiQ5j5f6uOw+FjhTA+WwxUhPNhgJS+VryCcLmmPVHTvMHpNsLUhKl7kfCETfSWSRVfrD1mMuJmraiU48oiDFY4CxDO9UMTtUDBjXefM11sKJnAJmZXnMJiQBlMiudcX0U47apWJRtCEtGelO5nQ38H4VhPmc02Fc1bZRXJk8xcTXDpWwVLTLPG6o7i7Yd6cXbOqIKV8G4YW2yuQ3Gil2IpNEbQG64YCFO2RXGbZJXHWLDpLQoNE01TxnjJcCXdT5UhoyMKU1PKyRwuU6g5ga2oI3DR96/ebb39/OV6e9wG6I2xnpSu7aD2Kx0qrm0fEA43ZyxCIfMLTM2VYdhwSavlVmeyS8BKK0wiiP+IhXkW5j1gpk7QzNDPr9+mnv4YgHQBRmTI/AKz+UUYxroml6H0Y3XrtlNycPsAneNWE8IQD2yHaOIP3fAZsumKCHyq3c2Y3E52ue1I+L77euHkm1PX2o5TTUX/pCWuM08gKwIpAu5Wq7U1fVdpVBke+WGyHf32JWXvKdWaqWl3zu61ZsPn7XEhjux10Um1X5fcf8f3ZaC5RpqffTj+Av/+oc4mBQAA";
    protected fr.ifremer.isisfish.entities.GearImpl bean;
    protected javax.swing.JTextField fieldGearParamPossibleValue;
    protected jaxx.runtime.swing.JAXXComboBox fieldGearParamType;
    private fr.ifremer.isisfish.ui.input.RangeOfValuesUI $InputContentUI0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource2 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearParamType.enabled");
    private java.beans.PropertyChangeListener $DataSource3 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearParamPossibleValue.enabled");
    private java.beans.PropertyChangeListener $DataSource4 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearParamPossibleValue.text");

    /* begin raw body code */
    boolean init;
    
    
    @Override
    public void refresh() {
        Gear gear = getVerifier().getEntity(Gear.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((GearImpl) gear);
        
        if (getBean() != null) {
            java.util.List<Object> values = new ArrayList<Object>();
            for (String value : RangeOfValues.getPossibleTypes()) {
                values.add(value);
            }
      
            jaxx.runtime.Util.assignment(init = true, "init", fr.ifremer.isisfish.ui.input.RangeOfValuesUI.this);
            jaxx.runtime.SwingUtil.fillComboBox(fieldGearParamType, values, getBean().getPossibleValue() == null ? null : getBean().getPossibleValue().getType(), true);
            jaxx.runtime.Util.assignment(init = false, "init", fr.ifremer.isisfish.ui.input.RangeOfValuesUI.this);
        }
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    protected void gearParamChanged() {
        if (fieldGearParamType.getSelectedItem() != null) {
            if (!init) {
                getBean().setPossibleValue(new RangeOfValues(fieldGearParamType.getSelectedItem().toString().concat("[" + fieldGearParamPossibleValue.getText() + "]")));
            }
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public RangeOfValuesUI() {
        super();
        $initialize();
    }

    public RangeOfValuesUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldGearParamType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource2);
            }
        } else if ("fieldGearParamPossibleValue.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource3);
            }
        } else if ("fieldGearParamPossibleValue.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource4);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("possibleValue", $DataSource4);
            }if ( getBean() != null) {
                 getBean().addPropertyChangeListener("possibleValue", $DataSource4);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldGearParamType.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearParamType.setEnabled((isActif()));
            }
            } else if ("fieldGearParamPossibleValue.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearParamPossibleValue.setEnabled((isActif()));
            }
            } else if ("fieldGearParamPossibleValue.text".equals($dest)) {
            if ( getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearParamPossibleValue, String.valueOf((getBean().getPossibleValue() == null ? "" : getBean().getPossibleValue().getValues())));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldGearParamType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource2);
            }
        } else if ("fieldGearParamPossibleValue.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource3);
            }
        } else if ("fieldGearParamPossibleValue.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource4);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("possibleValue", $DataSource4);
            }if ( getBean() != null) {
                 getBean().removePropertyChangeListener("possibleValue", $DataSource4);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldGearParamType(java.awt.event.ActionEvent event) {
        gearParamChanged();
    }

    public void doKeyReleased__on__fieldGearParamPossibleValue(java.awt.event.KeyEvent event) {
        gearParamChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.GearImpl getBean() {
        return bean;
    }

    public javax.swing.JTextField getFieldGearParamPossibleValue() {
        return fieldGearParamPossibleValue;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldGearParamType() {
        return fieldGearParamType;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.GearImpl newValue) {
        fr.ifremer.isisfish.entities.GearImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.RangeOfValuesUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        addChildrenToBody();
        applyDataBinding("fieldGearParamType.enabled");
        applyDataBinding("fieldGearParamPossibleValue.enabled");
        applyDataBinding("fieldGearParamPossibleValue.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        init = false;
        
        createFieldGearParamType();
        createFieldGearParamPossibleValue();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldGearParamPossibleValue.setText("");
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(fieldGearParamType, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldGearParamPossibleValue, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createFieldGearParamPossibleValue() {
        fieldGearParamPossibleValue = new javax.swing.JTextField();
        $objectMap.put("fieldGearParamPossibleValue", fieldGearParamPossibleValue);
        fieldGearParamPossibleValue.setName("fieldGearParamPossibleValue");
        fieldGearParamPossibleValue.setColumns(15);
        fieldGearParamPossibleValue.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearParamPossibleValue"));
    }

    protected void createFieldGearParamType() {
        fieldGearParamType = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldGearParamType", fieldGearParamType);
        fieldGearParamType.setName("fieldGearParamType");
        fieldGearParamType.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldGearParamType"));
    }

}
