/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2005 - 2010 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input;

import java.awt.event.MouseEvent;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;

import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.IsisMapBean;

/**
 * OpenMapEvents.java
 *
 * Created: 5 septembre 2005 03:21:41 CEST
 *
 * @author Benjamin POUSSIN <poussin@codelutin.com>
 * @version $Revision: 202 $
 *
 * Last update: $Date: 2006-06-30 18:39:09 +0200 (ven, 30 jun 2006) $
 * by : $Author: bpoussin $
 */
public abstract class OpenMapEvents extends Layer implements MapMouseListener { // OpenMapEvents

    /** serialVersionUID. */
    private static final long serialVersionUID = -8365120112075269288L;

    /**
     * SelectMouseMode property: Null, Distance, Nav, Select
     */
    protected MapMouseMode mouseMode;
    protected IsisMapBean map;
    
    protected int selectMode = CellSelectionLayer.SINGLE_SELECTION;
    
    /**
     * OnMouseDragged property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMouseDragged = null;
    
    /**
     * OnMouseEntered property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMouseEntered = null;
    
    /**
     * OnMouseExited property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMouseExited = null;
    
    /**
     * OnMouseMoved property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMouseMoved = null;
    
    /**
     * OnMousePressed property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMousePressed = null;
    
    /**
     * OnMouseReleased property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    protected String onMouseReleased = null;
    
    /**
     * Constructor.
     * 
     * Register himself to {@code map} mapMouseListener.
     * Also set mouseMode and selectMode on map.
     * 
     * @param map map bean
     * @param mouseMode mouse mode
     * @param selectMode select mode
     */
    public OpenMapEvents(IsisMapBean map, MapMouseMode mouseMode, int selectMode) {
        super();
        this.mouseMode = mouseMode;
        this.map = map;
        this.selectMode = selectMode;
        map.setSelectionMode(selectMode);
        map.setActiveMouseMode(mouseMode);
        map.addMapMouseListener(this);

    }

    @Override
    public void projectionChanged(ProjectionEvent e) {
        // do nothing, it's not reel layer
    }

    /**
     * Get onMouseDragged property.
     *
     * @return OnMouseDragged property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMouseDragged() {
        return this.onMouseDragged;
    }

    /**
     * Set onMouseDragged property.
     *
     * @param onMouseDragged New onMouseDragged property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMouseDragged(String onMouseDragged) {
        this.onMouseDragged = onMouseDragged;
    }

    /**
     * Get onMouseEntered property.
     *
     * @return OnMouseEntered property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMouseEntered() {
        return this.onMouseEntered;
    }

    /**
     * Set onMouseEntered property.
     *
     * @param onMouseEntered New onMouseEntered property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMouseEntered(String onMouseEntered) {
        this.onMouseEntered = onMouseEntered;
    }

    /**
     * Get onMouseExited property.
     *
     * @return OnMouseExited property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMouseExited() {
        return this.onMouseExited;
    }

    /**
     * Set onMouseExited property.
     *
     * @param onMouseExited New onMouseExited property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMouseExited(String onMouseExited) {
        this.onMouseExited = onMouseExited;
    }

    /**
     * Get onMouseMoved property.
     *
     * @return OnMouseMoved property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMouseMoved() {
        return this.onMouseMoved;
    }

    /**
     * Set onMouseMoved property.
     *
     * @param onMouseMoved New onMouseMoved property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMouseMoved(String onMouseMoved) {
        this.onMouseMoved = onMouseMoved;
    }

    /**
     * Get onMousePressed property.
     *
     * @return OnMousePressed property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMousePressed() {
        return this.onMousePressed;
    }

    /**
     * Set onMousePressed property.
     *
     * @param onMousePressed New onMousePressed property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMousePressed(String onMousePressed) {
        this.onMousePressed = onMousePressed;
    }

    /**
     * Get onMouseReleased property.
     *
     * @return OnMouseReleased property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public String getOnMouseReleased() {
        return this.onMouseReleased;
    }

    /**
     * Set onMouseReleased property.
     *
     * @param onMouseReleased New onMouseReleased property.
     * 
     * @deprecated as of 3.2.0.5 unused
     */
    public void setOnMouseReleased(String onMouseReleased) {
        this.onMouseReleased = onMouseReleased;
    }

    @Override
    public String[] getMouseModeServiceList() {
        return new String[] { SelectMouseMode.modeID };
    }

    @Override
    public boolean mouseClicked(MouseEvent e) {
        return true;
    }
    
    @Override
    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved() {
    }

    @Override
    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

} // OpenMapEvents
