/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.GearImpl;
import jaxx.runtime.swing.editor.NumberEditor;

public class GearTabUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS2/TQBDehqalQGlpaQHxamkBIYHDu0ARr0JLSsqjpQiRC5t4Q7dy1mZ33LoXhMQVIU4cuAB3jtwR4siJK/8BIf4Bs3bixMUYS87BSWbn++ab2fH38SfJK0lGl6nnGdIVwOvMmL368OGdyjKrwnWmqpI7YEsSfDpyJFcmm80wroCMlUsaXmjAC1N23bEFE23oyRLZpGDNYmqJMQAyFCCqShUWwvCk57iyyRaKiWN7//tX7rX5/EOOEM9BVcPYwsj/UK0OOkskx00gA1hphRYsKp6gDMnFE9TZq2NTFlXqNq2zp+QZ6S6RLodKJANyIH2rPoeP9xwg/eNF4bgwZQvA9MXicSCHatLgNcnqDL8VVzWulgyXG1wnGjOMyvu0slh0HJ+lC0hnhVEB5GAcDkk5cKZ8XLHuWO0w21wDsjMyILWK7RpYwGKtzO5xP3BC/92mH33h0cbx2RKtMOskjk1PyGswBFGdNBDm9tY4s0wtRI8QyHAEcJ95MK0ToqBmgVP6/3D0bDAkvFGr2RIWBQd9tCue4nQMxb6QYgGoMKk0uaLAbTFNq3hrCWxnYtgGQra7VNJ6c1P+wXA2hqFX4taxO7UH1HIZvkRHE5dhvj15sRhfZiKuzPjsQlXalnWXCnYOyI7IVbSOoqj+sD1c8Lq/+EN/3eFVyajOP7Z+fc7HrE+noiu4CYMRlmsugC10xqkwsatKRTVYqIn1J1gQWNwJjs1eiZxIXQrXHR3GaDlMywI6yiQvXUtPvr/cMqN5DAU21Ij6BH703Yu3K28+fb7Q9JwdWKM3ktJmkegBjrQdJvUrCaQvMBoXuFWYo85kmfQoZrFq4J/b2wQsNMIoAvm3aZihYcZNqpYQmu/+8eXr8OPvG0hummyybGoG+1skPbAksUvbMj3n8hVfyZbVjfjs15rwcpjQl4O2t/WiSYGOVLgw8Rouedjt9rZuQwnfXr+c2/Nq70Sz445A0bq0Vtf5R6SLC4sL5vtrwzpj/XSzo5hr2i2LjDPNDv095DTsacp/zsS11gm4jvhSXgyqj1BAM6+4wLA3Dbrli9e/5lJy6rD/ls3GM+xMxXAvM0OSht3pNcxnYUjSsDfzHNIxJGnYn3kO6RiSNIxmnkM6hiQNY5nnkI4hScPBzHNIx5Ck4XDmOfyfAUgebZfXEmQcydzI0cyNpGNI0nAi84Vqhj9aL4koZgwAAA==";
    protected fr.ifremer.isisfish.entities.GearImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldGearComment;
    protected javax.swing.JTextField fieldGearEffortUnit;
    protected javax.swing.JTextField fieldGearName;
    protected javax.swing.JTextField fieldGearParamName;
    protected javax.swing.JTextField fieldGearStandardisationFactor;
    protected fr.ifremer.isisfish.ui.input.RangeOfValuesUI rangeOfValues;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.GearTabUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JScrollPane $JScrollPane8;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table9;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearName.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearName.text");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearEffortUnit.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearEffortUnit.text");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearStandardisationFactor.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearStandardisationFactor.text");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearParamName.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearParamName.text");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "rangeOfValues.actif");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearComment.enabled");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldGearComment.text");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        Gear gear = getVerifier().getEntity(Gear.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((GearImpl) gear);
        
        getVerifier().addCurrentPanel(rangeOfValues);
        
        /* chatellier commented since number editor is not working
        if (getBean() != null) {
            fieldGearStandardisationFactor.init();
        }*/
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Gear");
        getVerifier().setDeleteButton(remove);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public GearTabUI() {
        super();
        $initialize();
    }

    public GearTabUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldGearName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldGearName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource12);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("fieldGearEffortUnit.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldGearEffortUnit.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("effortUnit", $DataSource15);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldGearStandardisationFactor.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldGearStandardisationFactor.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("standardisationFactor", $DataSource18);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource19);
            }
        } else if ("fieldGearParamName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldGearParamName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("parameterName", $DataSource21);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource22);
            }
        } else if ("rangeOfValues.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldGearComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource25);
            }
        } else if ("fieldGearComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource26);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldGearName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearName.setEnabled((isActif()));
            }
            } else if ("fieldGearName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearName, String.valueOf((getBean().getName())));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldGearEffortUnit.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearEffortUnit.setEnabled((isActif()));
            }
            } else if ("fieldGearEffortUnit.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearEffortUnit, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getEffortUnit()))));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldGearStandardisationFactor.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearStandardisationFactor.setEnabled((isActif()));
            }
            } else if ("fieldGearStandardisationFactor.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearStandardisationFactor, String.valueOf((getBean().getStandardisationFactor())));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldGearParamName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearParamName.setEnabled((isActif()));
            }
            } else if ("fieldGearParamName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearParamName, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getParameterName()))));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("rangeOfValues.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                rangeOfValues.setActif((isActif()));
            }
            } else if ("$JLabel7.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel7.setEnabled((isActif()));
            }
            } else if ("fieldGearComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldGearComment.setEnabled((isActif()));
            }
            } else if ("fieldGearComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldGearComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldGearName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldGearName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource12);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("fieldGearEffortUnit.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldGearEffortUnit.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("effortUnit", $DataSource15);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldGearStandardisationFactor.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldGearStandardisationFactor.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("standardisationFactor", $DataSource18);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource19);
            }
        } else if ("fieldGearParamName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldGearParamName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("parameterName", $DataSource21);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource22);
            }
        } else if ("rangeOfValues.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldGearComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource25);
            }
        } else if ("fieldGearComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource26);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldGearComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldGearComment.getText());
    }

    public void doKeyReleased__on__fieldGearEffortUnit(java.awt.event.KeyEvent event) {
        getBean().setEffortUnit(fieldGearEffortUnit.getText());
    }

    public void doKeyReleased__on__fieldGearName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldGearName.getText());
    }

    public void doKeyReleased__on__fieldGearParamName(java.awt.event.KeyEvent event) {
        getBean().setParameterName(fieldGearParamName.getText());
    }

    public void doKeyReleased__on__fieldGearStandardisationFactor(java.awt.event.KeyEvent event) {
        getBean().setStandardisationFactor(Double.parseDouble(fieldGearStandardisationFactor.getText()));
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.GearImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldGearComment() {
        return fieldGearComment;
    }

    public javax.swing.JTextField getFieldGearEffortUnit() {
        return fieldGearEffortUnit;
    }

    public javax.swing.JTextField getFieldGearName() {
        return fieldGearName;
    }

    public javax.swing.JTextField getFieldGearParamName() {
        return fieldGearParamName;
    }

    public javax.swing.JTextField getFieldGearStandardisationFactor() {
        return fieldGearStandardisationFactor;
    }

    public fr.ifremer.isisfish.ui.input.RangeOfValuesUI getRangeOfValues() {
        return rangeOfValues;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.GearImpl newValue) {
        fr.ifremer.isisfish.entities.GearImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.GearTabUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JScrollPane get$JScrollPane8() {
        return $JScrollPane8;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table9() {
        return $Table9;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldGearName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldGearEffortUnit), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldGearStandardisationFactor), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldGearParamName), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(rangeOfValues), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane8, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        addChildrenToFieldGearStandardisationFactor();
        
        
        addChildrenToRangeOfValues();
        
        $JScrollPane8.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldGearComment));
        
        $Table9.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldGearName.enabled");
        applyDataBinding("fieldGearName.text");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldGearEffortUnit.enabled");
        applyDataBinding("fieldGearEffortUnit.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldGearStandardisationFactor.enabled");
        applyDataBinding("fieldGearStandardisationFactor.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldGearParamName.enabled");
        applyDataBinding("fieldGearParamName.text");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("rangeOfValues.actif");
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldGearComment.enabled");
        applyDataBinding("fieldGearComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.gear.name"));
        
        createFieldGearName();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.gear.effortUnit"));
        
        createFieldGearEffortUnit();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.gear.standardisationFactor"));
        
        createFieldGearStandardisationFactor();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.gear.technicalParameter"));
        
        createFieldGearParamName();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.gear.rangeValues"));
        
        createRangeOfValues();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.gear.comments"));
        
        $JScrollPane8 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane8", $JScrollPane8);
        $JScrollPane8.setName("$JScrollPane8");
        
        createFieldGearComment();
        
        $Table9 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table9", $Table9);
        $Table9.setName("$Table9");
        
        createSave();
        createCancel();
        createCreate();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldGearName.setText("");
                    fieldGearEffortUnit.setText("");
                    fieldGearStandardisationFactor.setText("");
                    fieldGearParamName.setText("");
                    fieldGearComment.setText("");
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table9, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldGearStandardisationFactor() {
        if (!allComponentsCreated) {
            return;
        }
        fieldGearStandardisationFactor.putClientProperty("bean", GearImpl.class);
        fieldGearStandardisationFactor.putClientProperty("method", "StandardisationFactor");
    }

    protected void addChildrenToRangeOfValues() {
        if (!allComponentsCreated) {
            return;
        }
        rangeOfValues.putClientProperty("bean", GearImpl.class);
        rangeOfValues.putClientProperty("method", "PossibleValue");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldGearComment() {
        fieldGearComment = new javax.swing.JTextArea();
        $objectMap.put("fieldGearComment", fieldGearComment);
        fieldGearComment.setName("fieldGearComment");
        fieldGearComment.setColumns(15);
        fieldGearComment.setLineWrap(true);
        fieldGearComment.setWrapStyleWord(true);
        fieldGearComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearComment"));
    }

    protected void createFieldGearEffortUnit() {
        fieldGearEffortUnit = new javax.swing.JTextField();
        $objectMap.put("fieldGearEffortUnit", fieldGearEffortUnit);
        fieldGearEffortUnit.setName("fieldGearEffortUnit");
        fieldGearEffortUnit.setColumns(15);
        fieldGearEffortUnit.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearEffortUnit"));
    }

    protected void createFieldGearName() {
        fieldGearName = new javax.swing.JTextField();
        $objectMap.put("fieldGearName", fieldGearName);
        fieldGearName.setName("fieldGearName");
        fieldGearName.setColumns(15);
        fieldGearName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearName"));
    }

    protected void createFieldGearParamName() {
        fieldGearParamName = new javax.swing.JTextField();
        $objectMap.put("fieldGearParamName", fieldGearParamName);
        fieldGearParamName.setName("fieldGearParamName");
        fieldGearParamName.setColumns(15);
        fieldGearParamName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearParamName"));
    }

    protected void createFieldGearStandardisationFactor() {
        fieldGearStandardisationFactor = new javax.swing.JTextField();
        $objectMap.put("fieldGearStandardisationFactor", fieldGearStandardisationFactor);
        fieldGearStandardisationFactor.setName("fieldGearStandardisationFactor");
        fieldGearStandardisationFactor.setColumns(15);
        fieldGearStandardisationFactor.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldGearStandardisationFactor"));
    }

    protected void createRangeOfValues() {
        rangeOfValues =  new fr.ifremer.isisfish.ui.input.RangeOfValuesUI(this);
        $objectMap.put("rangeOfValues", rangeOfValues);
        rangeOfValues.removeDataBinding("$InputContentUI0.name");
        
        rangeOfValues.setName("rangeOfValues");
        rangeOfValues.removeDataBinding("$InputContentUI0.actif");
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
