/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.config;

import fr.ifremer.isisfish.ui.config.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSHLauncherConfigUI extends javax.swing.JDialog implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJ6Zx6vxoSxISQAWFEooAdU0oUQUplPwgJKlDWuxAwUIw9o7tqda7m5nZxMkBIThwqVBPHLgAd45cEap65MSV/wEh/gPe7PrXpt7xwsvBdmbe++z3+3Zm3+zPf5FRKchzd2mrZYnAVbzJrJ3VO3f2KndZVW0wWRXcV54g0d9IhmTKZMLujktFni8XdHq+nZ5f95q+5zK3L3ulQMalOnaYbDCmFHkiyqhKmS92h1dafiA6tK6YQbQf//k7c9/+8qcMIS0fVL0MFhaGZfUcnCmQDLcVmYYrHdK8Q906yBDcrYPOKT227lAp36dNdkC+IGMFkvWpAJgil9JbDRlhfstXJLe4s8Gp49VfVWSpJixeE6zJ4FtyWeOyYQXcqnpujdetYnGrQAO32mBiPRzZ3/b9kJRVJEurinuuIsv/EbIa5vVAOQh04RYzKMTj2rOl62CteZ7DaF/c2GKJVhy2pMiTsQrLI6iXFc7pyFw34ZyUjSITh0wUaIU5UGZNb7UTdsJBHTo9IGOTMwf0zMUySqylwol41lQgmXDhHnWJ8wkB3eSn4wETcN2b7Dgpvz2dlD0ZTa8FSun7MRPTHI3GE9qVfE3/Oxuv2QVg7YPahnfazuWBMXFN8ZgNqqhPVcPE6cSYONuwqLaG6OnEmDgl1vSH6enEmDg7UN9bQzidmCTONMTcqsg17ppI8agk1lwUdVsGlT1f7y2ZxHs00qRvl7ZKDcGonciLRyWx5iEKtr4SnrPtKthe1EkCDghNorYX8dUBi3hcMal6C/8F/VHo7SaAcjt5WjDJkrMnq9StMidxvi3r9QGyJptMSlo/tY4/7M6fXYyeScsD5ualoiqQm4IxvWUqVCZiZqrw3BSdqFNC+8J6RL3ok2jnQ5qOeJQk9LMGnsTQPa1e9+y1t5EyGRUBDMOeKPca7QcwFLXY9mgICEd/+Pr7w+9++e3NTj/dhGtMxUL62j/0N194PhOK60ucj5pooLiT36X+SpnkJHOgsYRng9k+AcX2MIgAftRzdJq1RfV69kfH/nzwcO7zPx4jmU0y7njU3qQ6fpvkFCx12fAcu+XfeCdUMnl0Fj4vaE3QFB167EGdyLnrNtyAhQp3bXgMv90Cs7N9ZrsKfr9/b/fit89c6xgeiQSdCuuZHv2EZLnrcJeFR4f2qWDgUWHClyywvV73H3QeGNHf4367y/LwsznIWQ588xO9tGHbX48kLFAFh5VKoBgY1JkHoQP9S6YGjyquos7d+v+QbMUTNhN63h9MmUlBOaOgwRuUzKVgTCg4t5S4X8Ki9PA9A+GpVIRvDISLaA14wrNoFwtoDXjCJbSLxVSErwwL/EW0hpfQdRhOgAbJXP0UsQ2YV9BC0hFMxbiC1oAn5NEultAa8ISraBfLaA14wjW0izfQGvCEFbSLt9Aa8IQbaBeraA14wjraxbtoDXjCe2gX22gNeMLNNKdDXo1efxIa8B66EukIvxo03E5DGLmMJRhd4DUU0RpSEYwa9tEa0hFMR7qP0ISP07yx1DxXXTlivN4wvbGkQc00PMFPAEedVYfX3SZzsciJJnd5M2gW+QlDGs16Pj0ITK+aaShTvmA1JgSz0ZKGraB0BNPzoIzWkI5g0vApmvAZejenIhjrkI5gckHRhCq6DqkIxjpowr9WIa4srBsAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected fr.ifremer.isisfish.ui.config.SSHLauncherConfigAction action;
    protected javax.swing.JButton cancelButton;
    protected javax.swing.JButton clearDatabaseButton;
    protected javax.swing.JButton clearTempButton;
    protected java.lang.Boolean connected;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JLabel messageLabel;
    protected javax.swing.JButton resetButton;
    protected javax.swing.JTextField sshControlIntervalField;
    protected javax.swing.JLabel sshControlIntervalLabel;
    protected javax.swing.JTextField sshDatapathField;
    protected javax.swing.JLabel sshDatapathLabel;
    protected javax.swing.JTextField sshIsisHomeField;
    protected javax.swing.JLabel sshIsisHomeLabel;
    protected javax.swing.JTextField sshJavaPathField;
    protected javax.swing.JLabel sshJavaPathLabel;
    protected javax.swing.JButton sshKeyButton;
    protected javax.swing.JTextField sshKeyField;
    protected javax.swing.JLabel sshKeyLabel;
    protected javax.swing.JTextField sshMaxThreadsField;
    protected javax.swing.JLabel sshMaxThreadsLabel;
    protected javax.swing.JTextField sshPbsBinPathField;
    protected javax.swing.JLabel sshPbsBinPathLabel;
    protected javax.swing.JTextField sshPbsQsubOptionsField;
    protected javax.swing.JLabel sshPbsQsubOptionsLabel;
    protected javax.swing.JTextField sshServerField;
    protected javax.swing.JLabel sshServerLabel;
    protected javax.swing.JTextField sshTemppathField;
    protected javax.swing.JLabel sshTemppathLabel;
    protected javax.swing.JTextField sshUserhomeField;
    protected javax.swing.JLabel sshUserhomeLabel;
    protected javax.swing.JLabel statusFreeDatabaseLabel;
    protected javax.swing.JLabel statusFreeTempLabel;
    protected javax.swing.JButton testButton;
    protected javax.swing.JTextField usernameField;
    protected javax.swing.JLabel usernameLabel;
    protected javax.swing.JButton validButton;
    private fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI $JDialog0 = this;
    private javax.swing.JLabel $JLabel5;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table3;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($JDialog0, "validButton.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($JDialog0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($JDialog0, "statusFreeDatabaseLabel.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($JDialog0, "clearDatabaseButton.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($JDialog0, "statusFreeTempLabel.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($JDialog0, "clearTempButton.enabled");

    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SSHLauncherConfigUI() {
        $initialize();
    }

    public SSHLauncherConfigUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("validButton.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource10);
        
        } else if ("$JLabel5.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource18);
        
        } else if ("statusFreeDatabaseLabel.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource19);
        
        } else if ("clearDatabaseButton.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource20);
        
        } else if ("statusFreeTempLabel.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource22);
        
        } else if ("clearTempButton.enabled".equals($binding)) {
                addPropertyChangeListener("connected", $DataSource23);
        
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("validButton.enabled".equals($dest)) {
            validButton.setEnabled((isConnected()));
            } else if ("$JLabel5.enabled".equals($dest)) {
            $JLabel5.setEnabled((isConnected()));
            } else if ("statusFreeDatabaseLabel.enabled".equals($dest)) {
            statusFreeDatabaseLabel.setEnabled((isConnected()));
            } else if ("clearDatabaseButton.enabled".equals($dest)) {
            clearDatabaseButton.setEnabled((isConnected()));
            } else if ("statusFreeTempLabel.enabled".equals($dest)) {
            statusFreeTempLabel.setEnabled((isConnected()));
            } else if ("clearTempButton.enabled".equals($dest)) {
            clearTempButton.setEnabled((isConnected()));
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("validButton.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource10);
        
        } else if ("$JLabel5.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource18);
        
        } else if ("statusFreeDatabaseLabel.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource19);
        
        } else if ("clearDatabaseButton.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource20);
        
        } else if ("statusFreeTempLabel.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource22);
        
        } else if ("clearTempButton.enabled".equals($binding)) {
                removePropertyChangeListener("connected", $DataSource23);
        
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(java.awt.event.ActionEvent event) {
        getAction().cancelSSHConfiguration();
    }

    public void doActionPerformed__on__clearDatabaseButton(java.awt.event.ActionEvent event) {
        getAction().clearDatabase();
    }

    public void doActionPerformed__on__clearTempButton(java.awt.event.ActionEvent event) {
        getAction().clearTempDirectory();
    }

    public void doActionPerformed__on__resetButton(java.awt.event.ActionEvent event) {
        getAction().resetSSHConfiguration();
    }

    public void doActionPerformed__on__sshKeyButton(java.awt.event.ActionEvent event) {
        getAction().generateSSHKey();
    }

    public void doActionPerformed__on__testButton(java.awt.event.ActionEvent event) {
        getAction().testSSHConfiguration();
    }

    public void doActionPerformed__on__validButton(java.awt.event.ActionEvent event) {
        getAction().saveSSHConfiguration();
    }

    public void doKeyReleased__on__sshControlIntervalField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshDatapathField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshIsisHomeField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshJavaPathField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshKeyField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshMaxThreadsField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshPbsBinPathField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshPbsQsubOptionsField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshServerField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshTemppathField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__sshUserhomeField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    public void doKeyReleased__on__usernameField(java.awt.event.KeyEvent event) {
        getAction().doCheck();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public fr.ifremer.isisfish.ui.config.SSHLauncherConfigAction getAction() {
        return action;
    }

    public javax.swing.JButton getCancelButton() {
        return cancelButton;
    }

    public javax.swing.JButton getClearDatabaseButton() {
        return clearDatabaseButton;
    }

    public javax.swing.JButton getClearTempButton() {
        return clearTempButton;
    }

    public java.lang.Boolean getConnected() {
        return connected;
    }

    public javax.swing.JLabel getMessageLabel() {
        return messageLabel;
    }

    public javax.swing.JButton getResetButton() {
        return resetButton;
    }

    public javax.swing.JTextField getSshControlIntervalField() {
        return sshControlIntervalField;
    }

    public javax.swing.JLabel getSshControlIntervalLabel() {
        return sshControlIntervalLabel;
    }

    public javax.swing.JTextField getSshDatapathField() {
        return sshDatapathField;
    }

    public javax.swing.JLabel getSshDatapathLabel() {
        return sshDatapathLabel;
    }

    public javax.swing.JTextField getSshIsisHomeField() {
        return sshIsisHomeField;
    }

    public javax.swing.JLabel getSshIsisHomeLabel() {
        return sshIsisHomeLabel;
    }

    public javax.swing.JTextField getSshJavaPathField() {
        return sshJavaPathField;
    }

    public javax.swing.JLabel getSshJavaPathLabel() {
        return sshJavaPathLabel;
    }

    public javax.swing.JButton getSshKeyButton() {
        return sshKeyButton;
    }

    public javax.swing.JTextField getSshKeyField() {
        return sshKeyField;
    }

    public javax.swing.JLabel getSshKeyLabel() {
        return sshKeyLabel;
    }

    public javax.swing.JTextField getSshMaxThreadsField() {
        return sshMaxThreadsField;
    }

    public javax.swing.JLabel getSshMaxThreadsLabel() {
        return sshMaxThreadsLabel;
    }

    public javax.swing.JTextField getSshPbsBinPathField() {
        return sshPbsBinPathField;
    }

    public javax.swing.JLabel getSshPbsBinPathLabel() {
        return sshPbsBinPathLabel;
    }

    public javax.swing.JTextField getSshPbsQsubOptionsField() {
        return sshPbsQsubOptionsField;
    }

    public javax.swing.JLabel getSshPbsQsubOptionsLabel() {
        return sshPbsQsubOptionsLabel;
    }

    public javax.swing.JTextField getSshServerField() {
        return sshServerField;
    }

    public javax.swing.JLabel getSshServerLabel() {
        return sshServerLabel;
    }

    public javax.swing.JTextField getSshTemppathField() {
        return sshTemppathField;
    }

    public javax.swing.JLabel getSshTemppathLabel() {
        return sshTemppathLabel;
    }

    public javax.swing.JTextField getSshUserhomeField() {
        return sshUserhomeField;
    }

    public javax.swing.JLabel getSshUserhomeLabel() {
        return sshUserhomeLabel;
    }

    public javax.swing.JLabel getStatusFreeDatabaseLabel() {
        return statusFreeDatabaseLabel;
    }

    public javax.swing.JLabel getStatusFreeTempLabel() {
        return statusFreeTempLabel;
    }

    public javax.swing.JButton getTestButton() {
        return testButton;
    }

    public javax.swing.JTextField getUsernameField() {
        return usernameField;
    }

    public javax.swing.JLabel getUsernameLabel() {
        return usernameLabel;
    }

    public javax.swing.JButton getValidButton() {
        return validButton;
    }

    public java.lang.Boolean isConnected() {
        return connected !=null && connected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAction(fr.ifremer.isisfish.ui.config.SSHLauncherConfigAction newValue) {
        fr.ifremer.isisfish.ui.config.SSHLauncherConfigAction oldValue = this.action;
        this.action = newValue;
        firePropertyChange("action", oldValue, newValue);
    }

    public void setConnected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.connected;
        this.connected = newValue;
        firePropertyChange("connected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI get$JDialog0() {
        return $JDialog0;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JDialog0.getContentPane().add($Table1);
        $JDialog0.getContentPane().add($Table2);
        $JDialog0.getContentPane().add($Table3);
        $JDialog0.getContentPane().add($Table4);
        
        $Table1.add(sshServerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshServerField, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(usernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(usernameField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshKeyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshKeyField, new GridBagConstraints(1, 2, 1, 1, 2.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(sshKeyButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table2.add(sshUserhomeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshUserhomeField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshDatapathLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshDatapathField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshIsisHomeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshIsisHomeField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshTemppathLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshTemppathField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshJavaPathLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshJavaPathField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshPbsBinPathLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshPbsBinPathField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshPbsQsubOptionsLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshPbsQsubOptionsField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshMaxThreadsLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshMaxThreadsField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshControlIntervalLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(sshControlIntervalField, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table3.add(testButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(validButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(resetButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(cancelButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $Table4.add(messageLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel5, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(statusFreeDatabaseLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(clearDatabaseButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(statusFreeTempLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(clearTempButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        $Table1.setBorder((BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.connection"))));
        $Table2.setBorder((BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.environment"))));
        testButton.setIcon((jaxx.runtime.Util.createImageIcon("connect.png")));
        applyDataBinding("validButton.enabled");
        validButton.setIcon((jaxx.runtime.Util.createImageIcon("accept.png")));
        resetButton.setIcon((jaxx.runtime.Util.createImageIcon("arrow_undo.png")));
        cancelButton.setIcon((jaxx.runtime.Util.createImageIcon("cancel.png")));
        $Table4.setBorder((BorderFactory.createTitledBorder(_("isisfish.simulator.ssh.configuration.status"))));
        messageLabel.setBorder((BorderFactory.createEtchedBorder(EtchedBorder.LOWERED)));
        messageLabel.setMinimumSize((new Dimension(0, 25)));
        messageLabel.setPreferredSize((new Dimension(0, 25)));
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("statusFreeDatabaseLabel.enabled");
        applyDataBinding("clearDatabaseButton.enabled");
        clearDatabaseButton.setIcon((jaxx.runtime.Util.createImageIcon("paintbrush.png")));
        applyDataBinding("statusFreeTempLabel.enabled");
        applyDataBinding("clearTempButton.enabled");
        clearTempButton.setIcon((jaxx.runtime.Util.createImageIcon("paintbrush.png")));
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createAction();
        createConnected();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        createSshServerLabel();
        createSshServerField();
        createUsernameLabel();
        createUsernameField();
        createSshKeyLabel();
        createSshKeyField();
        createSshKeyButton();
        
        $Table2 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table2", $Table2);
        $Table2.setName("$Table2");
        
        createSshUserhomeLabel();
        createSshUserhomeField();
        createSshDatapathLabel();
        createSshDatapathField();
        createSshIsisHomeLabel();
        createSshIsisHomeField();
        createSshTemppathLabel();
        createSshTemppathField();
        createSshJavaPathLabel();
        createSshJavaPathField();
        createSshPbsBinPathLabel();
        createSshPbsBinPathField();
        createSshPbsQsubOptionsLabel();
        createSshPbsQsubOptionsField();
        createSshMaxThreadsLabel();
        createSshMaxThreadsField();
        createSshControlIntervalLabel();
        createSshControlIntervalField();
        
        $Table3 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table3", $Table3);
        $Table3.setName("$Table3");
        
        createTestButton();
        createValidButton();
        createResetButton();
        createCancelButton();
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        createMessageLabel();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.simulator.ssh.configuration.freespace"));
        
        createStatusFreeDatabaseLabel();
        createClearDatabaseButton();
        createStatusFreeTempLabel();
        createClearTempButton();
        $JDialog0.setName("$JDialog0");
        $JDialog0.getContentPane().setLayout((new BoxLayout(this.getContentPane(), BoxLayout.PAGE_AXIS)));
        $JDialog0.setResizable(false);
        $JDialog0.setTitle(_("isisfish.simulator.ssh.configuration.title"));
        
        
        // fill default values
            getAction().resetSSHConfiguration();
        $completeSetup();
    }

    protected void createAction() {
        action = new SSHLauncherConfigAction(this);
        $objectMap.put("action", action);
    }

    protected void createCancelButton() {
        cancelButton = new javax.swing.JButton();
        $objectMap.put("cancelButton", cancelButton);
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("isisfish.common.cancel"));
        cancelButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__cancelButton"));
    }

    protected void createClearDatabaseButton() {
        clearDatabaseButton = new javax.swing.JButton();
        $objectMap.put("clearDatabaseButton", clearDatabaseButton);
        clearDatabaseButton.setName("clearDatabaseButton");
        clearDatabaseButton.setText(_("isisfish.common.clear"));
        clearDatabaseButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__clearDatabaseButton"));
    }

    protected void createClearTempButton() {
        clearTempButton = new javax.swing.JButton();
        $objectMap.put("clearTempButton", clearTempButton);
        clearTempButton.setName("clearTempButton");
        clearTempButton.setText(_("isisfish.common.clear"));
        clearTempButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__clearTempButton"));
    }

    protected void createConnected() {
        connected = false;
        $objectMap.put("connected", connected);
    }

    protected void createMessageLabel() {
        messageLabel = new javax.swing.JLabel();
        $objectMap.put("messageLabel", messageLabel);
        messageLabel.setName("messageLabel");
        if (messageLabel.getFont() != null) messageLabel.setFont(messageLabel.getFont().deriveFont(messageLabel.getFont().getStyle() | Font.BOLD));
        messageLabel.setHorizontalAlignment(0);
        messageLabel.setOpaque(true);
        messageLabel.setText(_(""));
    }

    protected void createResetButton() {
        resetButton = new javax.swing.JButton();
        $objectMap.put("resetButton", resetButton);
        resetButton.setName("resetButton");
        resetButton.setText(_("isisfish.common.reset"));
        resetButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__resetButton"));
    }

    protected void createSshControlIntervalField() {
        sshControlIntervalField = new javax.swing.JTextField();
        $objectMap.put("sshControlIntervalField", sshControlIntervalField);
        sshControlIntervalField.setName("sshControlIntervalField");
        sshControlIntervalField.setColumns(15);
        sshControlIntervalField.setToolTipText(_("isisfish.config.main.simulation.ssh.control.check.interval.description"));
        sshControlIntervalField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshControlIntervalField"));
    }

    protected void createSshControlIntervalLabel() {
        sshControlIntervalLabel = new javax.swing.JLabel();
        $objectMap.put("sshControlIntervalLabel", sshControlIntervalLabel);
        sshControlIntervalLabel.setName("sshControlIntervalLabel");
        sshControlIntervalLabel.setText(_("isisfish.config.main.simulation.ssh.control.check.interval"));
        sshControlIntervalLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.control.check.interval.description"));
    }

    protected void createSshDatapathField() {
        sshDatapathField = new javax.swing.JTextField();
        $objectMap.put("sshDatapathField", sshDatapathField);
        sshDatapathField.setName("sshDatapathField");
        sshDatapathField.setColumns(15);
        sshDatapathField.setToolTipText(_("isisfish.config.main.simulation.ssh.datapath.description"));
        sshDatapathField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshDatapathField"));
    }

    protected void createSshDatapathLabel() {
        sshDatapathLabel = new javax.swing.JLabel();
        $objectMap.put("sshDatapathLabel", sshDatapathLabel);
        sshDatapathLabel.setName("sshDatapathLabel");
        sshDatapathLabel.setText(_("isisfish.config.main.simulation.ssh.datapath"));
        sshDatapathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.datapath.description"));
    }

    protected void createSshIsisHomeField() {
        sshIsisHomeField = new javax.swing.JTextField();
        $objectMap.put("sshIsisHomeField", sshIsisHomeField);
        sshIsisHomeField.setName("sshIsisHomeField");
        sshIsisHomeField.setColumns(15);
        sshIsisHomeField.setToolTipText(_("isisfish.config.main.simulation.ssh.isis.home.description"));
        sshIsisHomeField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshIsisHomeField"));
    }

    protected void createSshIsisHomeLabel() {
        sshIsisHomeLabel = new javax.swing.JLabel();
        $objectMap.put("sshIsisHomeLabel", sshIsisHomeLabel);
        sshIsisHomeLabel.setName("sshIsisHomeLabel");
        sshIsisHomeLabel.setText(_("isisfish.config.main.simulation.ssh.isis.home"));
        sshIsisHomeLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.isis.home.description"));
    }

    protected void createSshJavaPathField() {
        sshJavaPathField = new javax.swing.JTextField();
        $objectMap.put("sshJavaPathField", sshJavaPathField);
        sshJavaPathField.setName("sshJavaPathField");
        sshJavaPathField.setColumns(15);
        sshJavaPathField.setToolTipText(_("isisfish.config.main.simulation.ssh.javapath.description"));
        sshJavaPathField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshJavaPathField"));
    }

    protected void createSshJavaPathLabel() {
        sshJavaPathLabel = new javax.swing.JLabel();
        $objectMap.put("sshJavaPathLabel", sshJavaPathLabel);
        sshJavaPathLabel.setName("sshJavaPathLabel");
        sshJavaPathLabel.setText(_("isisfish.config.main.simulation.ssh.javapath"));
        sshJavaPathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.javapath.description"));
    }

    protected void createSshKeyButton() {
        sshKeyButton = new javax.swing.JButton();
        $objectMap.put("sshKeyButton", sshKeyButton);
        sshKeyButton.setName("sshKeyButton");
        sshKeyButton.setText(_("isisfish.simulator.ssh.configuration.keygenerate"));
        sshKeyButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__sshKeyButton"));
    }

    protected void createSshKeyField() {
        sshKeyField = new javax.swing.JTextField();
        $objectMap.put("sshKeyField", sshKeyField);
        sshKeyField.setName("sshKeyField");
        sshKeyField.setColumns(15);
        sshKeyField.setToolTipText(_("isisfish.config.ssh.key.file.description"));
        sshKeyField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshKeyField"));
    }

    protected void createSshKeyLabel() {
        sshKeyLabel = new javax.swing.JLabel();
        $objectMap.put("sshKeyLabel", sshKeyLabel);
        sshKeyLabel.setName("sshKeyLabel");
        sshKeyLabel.setText(_("isisfish.config.ssh.key.file"));
        sshKeyLabel.setToolTipText(_("isisfish.config.ssh.key.file.description"));
    }

    protected void createSshMaxThreadsField() {
        sshMaxThreadsField = new javax.swing.JTextField();
        $objectMap.put("sshMaxThreadsField", sshMaxThreadsField);
        sshMaxThreadsField.setName("sshMaxThreadsField");
        sshMaxThreadsField.setColumns(15);
        sshMaxThreadsField.setToolTipText(_("isisfish.config.main.simulation.ssh.max.threads.description"));
        sshMaxThreadsField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshMaxThreadsField"));
    }

    protected void createSshMaxThreadsLabel() {
        sshMaxThreadsLabel = new javax.swing.JLabel();
        $objectMap.put("sshMaxThreadsLabel", sshMaxThreadsLabel);
        sshMaxThreadsLabel.setName("sshMaxThreadsLabel");
        sshMaxThreadsLabel.setText(_("isisfish.config.main.simulation.ssh.max.threads"));
        sshMaxThreadsLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.max.threads.description"));
    }

    protected void createSshPbsBinPathField() {
        sshPbsBinPathField = new javax.swing.JTextField();
        $objectMap.put("sshPbsBinPathField", sshPbsBinPathField);
        sshPbsBinPathField.setName("sshPbsBinPathField");
        sshPbsBinPathField.setColumns(15);
        sshPbsBinPathField.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsbinpath.description"));
        sshPbsBinPathField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshPbsBinPathField"));
    }

    protected void createSshPbsBinPathLabel() {
        sshPbsBinPathLabel = new javax.swing.JLabel();
        $objectMap.put("sshPbsBinPathLabel", sshPbsBinPathLabel);
        sshPbsBinPathLabel.setName("sshPbsBinPathLabel");
        sshPbsBinPathLabel.setText(_("isisfish.config.main.simulation.ssh.pbsbinpath"));
        sshPbsBinPathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsbinpath.description"));
    }

    protected void createSshPbsQsubOptionsField() {
        sshPbsQsubOptionsField = new javax.swing.JTextField();
        $objectMap.put("sshPbsQsubOptionsField", sshPbsQsubOptionsField);
        sshPbsQsubOptionsField.setName("sshPbsQsubOptionsField");
        sshPbsQsubOptionsField.setColumns(15);
        sshPbsQsubOptionsField.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions.description"));
        sshPbsQsubOptionsField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshPbsQsubOptionsField"));
    }

    protected void createSshPbsQsubOptionsLabel() {
        sshPbsQsubOptionsLabel = new javax.swing.JLabel();
        $objectMap.put("sshPbsQsubOptionsLabel", sshPbsQsubOptionsLabel);
        sshPbsQsubOptionsLabel.setName("sshPbsQsubOptionsLabel");
        sshPbsQsubOptionsLabel.setText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions"));
        sshPbsQsubOptionsLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.pbsqsuboptions.description"));
    }

    protected void createSshServerField() {
        sshServerField = new javax.swing.JTextField();
        $objectMap.put("sshServerField", sshServerField);
        sshServerField.setName("sshServerField");
        sshServerField.setColumns(15);
        sshServerField.setToolTipText(_("isisfish.config.main.simulation.ssh.server.description"));
        sshServerField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshServerField"));
    }

    protected void createSshServerLabel() {
        sshServerLabel = new javax.swing.JLabel();
        $objectMap.put("sshServerLabel", sshServerLabel);
        sshServerLabel.setName("sshServerLabel");
        sshServerLabel.setText(_("isisfish.config.main.simulation.ssh.server"));
        sshServerLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.server.description"));
    }

    protected void createSshTemppathField() {
        sshTemppathField = new javax.swing.JTextField();
        $objectMap.put("sshTemppathField", sshTemppathField);
        sshTemppathField.setName("sshTemppathField");
        sshTemppathField.setColumns(15);
        sshTemppathField.setToolTipText(_("isisfish.config.main.simulation.ssh.tmppath.description"));
        sshTemppathField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshTemppathField"));
    }

    protected void createSshTemppathLabel() {
        sshTemppathLabel = new javax.swing.JLabel();
        $objectMap.put("sshTemppathLabel", sshTemppathLabel);
        sshTemppathLabel.setName("sshTemppathLabel");
        sshTemppathLabel.setText(_("isisfish.config.main.simulation.ssh.tmppath"));
        sshTemppathLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.tmppath.description"));
    }

    protected void createSshUserhomeField() {
        sshUserhomeField = new javax.swing.JTextField();
        $objectMap.put("sshUserhomeField", sshUserhomeField);
        sshUserhomeField.setName("sshUserhomeField");
        sshUserhomeField.setColumns(15);
        sshUserhomeField.setEnabled(false);
        sshUserhomeField.setToolTipText(_("isisfish.config.main.simulation.ssh.userhome.description"));
        sshUserhomeField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__sshUserhomeField"));
    }

    protected void createSshUserhomeLabel() {
        sshUserhomeLabel = new javax.swing.JLabel();
        $objectMap.put("sshUserhomeLabel", sshUserhomeLabel);
        sshUserhomeLabel.setName("sshUserhomeLabel");
        sshUserhomeLabel.setText(_("isisfish.config.main.simulation.ssh.userhome"));
        sshUserhomeLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.userhome.description"));
    }

    protected void createStatusFreeDatabaseLabel() {
        statusFreeDatabaseLabel = new javax.swing.JLabel();
        $objectMap.put("statusFreeDatabaseLabel", statusFreeDatabaseLabel);
        statusFreeDatabaseLabel.setName("statusFreeDatabaseLabel");
    }

    protected void createStatusFreeTempLabel() {
        statusFreeTempLabel = new javax.swing.JLabel();
        $objectMap.put("statusFreeTempLabel", statusFreeTempLabel);
        statusFreeTempLabel.setName("statusFreeTempLabel");
    }

    protected void createTestButton() {
        testButton = new javax.swing.JButton();
        $objectMap.put("testButton", testButton);
        testButton.setName("testButton");
        testButton.setText(_("isisfish.simulator.ssh.configuration.test"));
        testButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__testButton"));
    }

    protected void createUsernameField() {
        usernameField = new javax.swing.JTextField();
        $objectMap.put("usernameField", usernameField);
        usernameField.setName("usernameField");
        usernameField.setColumns(15);
        usernameField.setToolTipText(_("isisfish.config.main.simulation.ssh.username.description"));
        usernameField.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $JDialog0, "doKeyReleased__on__usernameField"));
    }

    protected void createUsernameLabel() {
        usernameLabel = new javax.swing.JLabel();
        $objectMap.put("usernameLabel", usernameLabel);
        usernameLabel.setName("usernameLabel");
        usernameLabel.setText(_("isisfish.config.main.simulation.ssh.username"));
        usernameLabel.setToolTipText(_("isisfish.config.main.simulation.ssh.username.description"));
    }

    protected void createValidButton() {
        validButton = new javax.swing.JButton();
        $objectMap.put("validButton", validButton);
        validButton.setName("validButton");
        validButton.setText(_("isisfish.common.valid"));
        validButton.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JDialog0, "doActionPerformed__on__validButton"));
    }

}
