/*
 * #%L
 * IsisFish
 * 
 * $Id: Date.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2005 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.types;

import java.io.Serializable;
import static org.nuiton.i18n.I18n._;

/**
 * This object can't be modified. If this beaviour is modified pay attention
 * if you used date as key in Map, in this case you will have error
 * 
 * @author poussin
 */
public class Date implements Cloneable, Serializable, Comparable<Date> { // Date

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected int date = 0;

    public Date() {
    }

    public Date(int date) {
        this.date = date;
    }

    public int compareTo(Date d) {
        if (this.before(d))
            return -1;
        else if (this.after(d))
            return 1;
        else
            return 0;
    }

    public int getYear() {
        return date / 12;
    }

    public Month getMonth() {
        int tmp = date;
        while (tmp < 0) {
            tmp += 12;
        }
        Month result = Month.MONTH[tmp % 12];
        return result;
    }

    // public Date inc() {
    // date++;
    // return this;
    // }

    public int getDate() {
        return date;
    }

    /**
     * Method next retourne une nouvelle date qui est la date suivante de la
     * date courante. la date courante n'est pas modifier.
     * 
     * @return Date
     */
    public Date next() {
        return new Date(this.date + 1);
    }

    /**
     * Method preview retourne une nouvelle date qui est la date precedente de
     * la date courante la date courante n'est pas modifier.
     * 
     * @return Date
     */
    public Date previous() {
        return new Date(this.date - 1);
    }

    /**
     * Method next retourne une nouvelle date qui est le meme mois de l'annee
     * suivante de la date courante. la date courante n'est pas modifier.
     * 
     * @return Date
     */
    public Date nextYear() {
        return new Date(this.date + 12);
    }

    /**
     * Method preview retourne une nouvelle date qui est le meme mois de l'annee
     * precedente de la date courante la date courante n'est pas modifier.
     * 
     * @return Date
     */
    public Date previousYear() {
        return new Date(this.date - 12);
    }
    
    
    /**
     * compare 2 dates.
     * 
     * @return retourne vrai si d est strictement superieur
     */
    public boolean before(Date d) {
        return this.date < d.date;
    }

    public boolean beforeOrEquals(Date d) {
        return this.date <= d.date;
    }

    /**
     * compare 2 dates.
     * 
     * @return retourne vrai si d est strictement inferieur
     */
    public boolean after(Date d) {
        return this.date > d.date;
    }

    public boolean afterOrEquals(Date d) {
        return this.date >= d.date;
    }

    public boolean equals(Object o) {
        if (o instanceof Date)
            return date == ((Date) o).date;
        return false;
    }

    public int hashCode() {
        return date;
    }

    /**
     * @param date2
     * @return month array
     */
    public Month[] getMonthBetweenDate(Date date2) {
        if(date2.getDate() - getDate() <0) {
            return new Month[0];
        }

        Month[] result = new Month[date2.getDate() - getDate()];
        Month month = getMonth();
        for (int i=0; i<result.length; i++) {
            month = month.next();
            result[i] = month;
        }
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = _("isisfish.date.toString", getMonth(), getYear());
        return result;
    }
    
} // Date

