/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import fr.ifremer.isisfish.simulator.sensitivity.visitor.DesignPlanVisitor;

/**
 * Design plan contenant toutes les
 * valeur de facteur possible.
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 19 févr. 2009 $
 * By : $Author: chatellier $
 */
public class DesignPlan implements Serializable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 977975461743758075L;

    /** Liste des facteurs a utiliser */
    protected List<Factor<?, ?>> factors;
    
    /**
     * Constructor.
     */
    public DesignPlan() {
        factors = new ArrayList<Factor<?, ?>>();
    }

    /**
     * Get factors list.
     * 
     * @return factors list
     */
    public List<Factor<?, ?>> getFactors() {
        return factors;
    }

    /**
     * Set factors list.
     * 
     * @param factors the factors list to set
     */
    public void setFactors(List<Factor<?, ?>> factors) {
        this.factors = factors;
    }

    /**
     * Accept a new visitor.
     * 
     * @param visitor
     */
    public void accept(DesignPlanVisitor visitor) {
        visitor.start(this);
        for (Factor<?, ?> factor : factors) {
            visitor.visit(this, factor);
        }
        visitor.end(this);
    }
}
