/*
 * #%L
 * IsisFish
 * 
 * $Id: AnalysePlan.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * AnalysePlan.java
 *
 * Created: 1 mars 07 20:27:28
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 * 
 * TODO will be renamed to SimulationPlan soon
 */
public interface AnalysePlan {

    /**
     * Return plan necessary Results.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return plan description.
     * 
     * @return plan description
     * @throws Exception
     */
    public String getDescription() throws Exception;

    /**
     * Use only once before first simulation.
     * 
     * You can modified Param for all simulation or put value in context.values.
     * 
     * @param context plan context
     * @throws Exception
     */
    public void init(AnalysePlanContext context) throws Exception;

    /**
     * Call before each simulation.
     * 
     * @param context plan context
     * @param nextSimulation storage used for next simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean beforeSimulation(AnalysePlanContext context,
            SimulationStorage nextSimulation) throws Exception;

    /**
     * Call after each simulation.
     * 
     * @param context plan context
     * @param lastSimulation storage used for simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean afterSimulation(AnalysePlanContext context,
            SimulationStorage lastSimulation) throws Exception;

}
