/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleHelper.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.rule;

import java.util.Map;
import java.util.Properties;

import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.util.ConverterUtil;

/**
 * Helper pour effectuer des manipulations sur les règles.
 * 
 * Permet de :
 * <ul>
 * <li>affecter les valeurs aux parametres des règles
 * </ul>
 * 
 * Created: 6 juin 07 12:03:42
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public class RuleHelper {

    /** Logger for this class. */
    private static final Log log = LogFactory.getLog(RuleHelper.class);

    /**
     * Recupere dans propriétés les valeurs des champs spécifiques à la règle et
     * met à jour les champs de la règle.
     * 
     * @param ruleIndex l'index de la règle
     * @param rule la règle dont les paramètres doivent être lu depuis les
     *        propriétés
     * @param region le topia context dont on a besoin
     * @param props les propriétés contenant les paramètres de la règle
     * 
     * @deprecated use {@link #populateRule(int, TopiaContext , Rule, Properties)} instead.
     */
    @Deprecated
    public static void populateRule(int ruleIndex, RegionStorage region, Rule rule, Properties props) {
        populateRule(ruleIndex, region.getStorage(), rule, props);
    }

    /**
     * Recupere dans propriétés les valeurs des champs spécifiques à la règle et
     * met à jour les champs de la règle.
     * 
     * @param ruleIndex l'index de la règle
     * @param rule la règle dont les paramètres doivent être lu depuis les
     *        propriétés
     * @param context le topia context dont on a besoin
     * @param props les propriétés contenant les paramètres de la règle
     */
    public static void populateRule(int ruleIndex, TopiaContext context, Rule rule, Properties props) {
        String ruleName = RuleStorage.getName(rule);
        String paramTag = "rule." + ruleIndex + ".parameter.";

        for (Map.Entry<String, Class<?>> entry : RuleStorage.getParameterNames(rule).entrySet()) {
            String propName = entry.getKey();
            Class<?> type = entry.getValue();
            if (TopiaEntity.class.isAssignableFrom(type)) {
                type = TopiaEntity.class;
            }
            String valueString = "not initialized";
            try {
                valueString = props.getProperty(paramTag + propName);

                if (log.isDebugEnabled()) {
                    log.debug("About to convert rule param: " + paramTag + propName + " = " + valueString);
                }

                // ATTENTION il semblerait que notre intance de beanUtils
                // soit ecrasé par celle du MatrixType ...
                // a ne pas deplacer avant la boucle
                ConvertUtilsBean beanUtils = ConverterUtil
                        .getConverter(context);
                Object value = beanUtils.convert(valueString, type);

                if (log.isDebugEnabled()) {
                    log.debug("Set rule param: " + paramTag + propName + " = " + value + "(" + valueString + ")");
                }
                RuleStorage.setParameterValue(rule, propName, value);
            } catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.info("Properties: " + props);
                    log.warn("Can't reload field " + propName + " for rule " + ruleName + " with value " + valueString, eee);
                }
            }
        }
    }
}
