/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin, CHatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import java.util.List;

import org.dom4j.Element;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;

import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;

/**
 * Parse xml using dom.
 * 
 * @see Element
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 13 mars 2009 $
 * By : $Author: chatellier $
 */
public class DomXMLParser {

    /**
     * Parse element root node as Design plan.
     * 
     * @param rootElement root dom element
     * @param topiaContext database context
     * @return a {@link DesignPlan}
     */
    public static DesignPlan parseDesignPlan(Element rootElement, TopiaContext topiaContext) {

        DesignPlan plan = new DesignPlan();

        List<Element> factorElements = rootElement
                .selectNodes("child::factors/factor");

        for (Element factorElement : factorElements) {
            String type = factorElement.attributeValue("type");
            String name = factorElement.attributeValue("name");
            String property = factorElement.attributeValue("property");
            String path = factorElement.element("target").getText().trim();

            // double
            if ("real".equals(type)) {
                Factor<Double,Integer> factor = new Factor<Double,Integer>(name);
                factor.setPath(path);
                Element fixedElement = factorElement.element("domain").element(
                        "fixed");
                // tous les domaines continues
                if (property.endsWith("continuous")) {

                    ContinuousDomain domain;
                    if(property.equals("matrixcontinuous")) {
                        // matrix specific
                        // <coefficient operator="-" value="0.799"/>
                        MatrixContinuousDomain mdomain = new MatrixContinuousDomain();
                        Element coefficientElement = fixedElement.element("coefficient");
                        mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        mdomain.setOperator(coefficientElement.attributeValue("operator"));
                        
                        // <mx name="test1" step="0">...
                        Element matrixElement = fixedElement.element("mx");
                        MatrixND matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        mdomain.setMatrix(matrix);

                        domain = mdomain;
                    }
                    else if (property.equals("equationcontinuous")) {
                        // equation specific
                        EquationContinuousDomain edomain = new EquationContinuousDomain();
                        Element coefficientElement = fixedElement.element("coefficient");
                        edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        edomain.setOperator(coefficientElement.attributeValue("operator"));
                        
                        Element equationElement = fixedElement.element("equation");
                        edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue("reference")));
                        edomain.setVariableName(equationElement.attributeValue("variable"));

                        domain = edomain;
                    }
                    else {
                        // continous domain
                        domain = new ContinuousDomain<Double,Double>();
                    }
                    
                    domain.setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));
                    
                    // <range max="1.0" min="0.0"/>
                    Element rangeElement = fixedElement.element("range");
                    domain.setMinBound(Double.valueOf(rangeElement.attributeValue("min")));
                    domain.setMaxBound(Double.valueOf(rangeElement.attributeValue("max")));

                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    DiscreteDomain<Double,Integer> domain = new DiscreteDomain<Double,Integer>();
                    List<Element> valueElements = fixedElement.element(
                            "enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        domain.getValues().put(Integer.valueOf(label),
                                Double.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                plan.getFactors().add(factor);
            } else if ("integer".equals(type)) {
                Factor<Integer,Integer> factor = new Factor<Integer,Integer>(name);
                factor.setPath(path);
                Element fixedElement = factorElement.element("domain").element("fixed");
                if ("continuous".equals(property)) {
                    ContinuousDomain domain = null;

                    if(property.equals("matrixcontinuous")) {
                        // matrix specific
                        MatrixContinuousDomain mdomain = new MatrixContinuousDomain();

                        Element coefficientElement = fixedElement.element("coefficient");
                        mdomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        mdomain.setOperator(coefficientElement.attributeValue("operator"));

                        // matrix specific
                        Element matrixElement = fixedElement.element("mx");
                        MatrixND matrix = MexicoHelper.getMatrixFromXml(matrixElement, topiaContext);
                        mdomain.setMatrix(matrix);

                        domain = mdomain;
                    }
                    else if (property.equals("equationcontinuous")) {
                        // equation specific
                        
                        EquationContinuousDomain edomain = new EquationContinuousDomain();
                        
                        Element coefficientElement = fixedElement.element("coefficient");
                        edomain.setCoefficient(Double.valueOf(coefficientElement.attributeValue("value")));
                        edomain.setOperator(coefficientElement.attributeValue("operator"));
                        
                        Element equationElement = fixedElement.element("equation");
                        edomain.setReferenceValue(Double.valueOf(equationElement.attributeValue("reference")));
                        edomain.setVariableName(equationElement.attributeValue("variable"));

                        domain = edomain;
                    }
                    else {
                        // continous domain
                        domain = new ContinuousDomain<Integer,Integer>();
                    }

                    domain.setCardinality(Integer.valueOf(fixedElement.attributeValue("cardinality")));

                    // <range max="1" min="3"/>
                    Element rangeElement = fixedElement.element("range");
                    domain.setMinBound(Integer.valueOf(rangeElement.attributeValue("min")));
                    domain.setMaxBound(Integer.valueOf(rangeElement.attributeValue("max")));

                    factor.setDomain(domain);
                } else if ("discrete".equals(property)) {
                    DiscreteDomain<Integer,Integer> domain = new DiscreteDomain<Integer,Integer>();
                    List<Element> valueElements = fixedElement.element(
                            "enumeration").elements("value");
                    int label = 0;
                    for (Element valueElement : valueElements) {
                        domain.getValues().put(Integer.valueOf(label),
                                Integer.valueOf(valueElement.getTextTrim()));
                        ++label;
                    }
                    factor.setDomain(domain);
                }
                plan.getFactors().add(factor);
            }
        }

        return plan;
    }

    /*
     * Parse element root node as Sensitivity Scenarios.
     * 
     * @return a {@link SensitivityScenarios}
     * 
     * TODO : non finished and untested
     *
    public static SensitivityScenarios parseSensitivityScenarios(
            Element rootElement) {

        SensitivityScenarios scenarios = new SensitivityScenarios();

        List<Element> scenarioElements = rootElement
                .selectNodes("child::scenarios/scenario");

        for (Element scenarioElement : scenarioElements) {

            Scenario scenario = new Scenario();
            List<Element> factorElements = scenarioElement.elements("factor");

            for (Element factorElement : factorElements) {
                String type = factorElement.attributeValue("type");
                String name = factorElement.attributeValue("name");
                String property = factorElement.attributeValue("property");
                String path = factorElement.element("target").getText().trim();

                // double
                if ("real".equals(type)) {
                    Factor<Double> factor = new Factor<Double>(name);
                    factor.setPath(path);
                    factor.setValue(Double.valueOf(factorElement.element(
                            "value").getText().trim()));

                    Element fixedElement = factorElement.element("domain")
                            .element("fixed");
                    if ("continuous".equals(property)) {
                        ContinuousDomain<Double> domain = new ContinuousDomain<Double>();
                        domain.setCardinality(Integer.valueOf(fixedElement
                                .attributeValue("cardinality")));
                        Element rangeElement = fixedElement.element("range");
                        domain.setMinBound(Double.valueOf(rangeElement
                                .attributeValue("min")));
                        domain.setMaxBound(Double.valueOf(rangeElement
                                .attributeValue("max")));
                        factor.setDomain(domain);
                    } else if ("discrete".equals(property)) {
                        DiscreteDomain<Double> domain = new DiscreteDomain<Double>();
                        List<Element> valueElements = fixedElement.element(
                                "enumeration").elements("value");
                        int label = 0;
                        for (Element valueElement : valueElements) {
                            domain.getValues().put(
                                    Integer.valueOf(label),
                                    Double.valueOf(valueElement.getText()
                                            .trim()));
                            ++label;
                        }
                        factor.setDomain(domain);
                    }
                    scenario.getFactors().add(factor);
                } else if ("integer".equals(type)) {
                    Factor<Integer> factor = new Factor<Integer>(name);
                    factor.setPath(path);
                    factor.setValue(Integer.valueOf(factorElement.element(
                            "value").getText().trim()));

                    Element fixedElement = factorElement.element("domain")
                            .element("fixed");
                    if ("continuous".equals(property)) {
                        ContinuousDomain<Integer> domain = new ContinuousDomain<Integer>();
                        domain.setCardinality(Integer.valueOf(fixedElement
                                .attributeValue("cardinality")));
                        Element rangeElement = fixedElement.element("range");
                        domain.setMinBound(Integer.valueOf(rangeElement
                                .attributeValue("min")));
                        domain.setMaxBound(Integer.valueOf(rangeElement
                                .attributeValue("max")));
                        factor.setDomain(domain);
                    } else if ("discrete".equals(property)) {
                        DiscreteDomain<Integer> domain = new DiscreteDomain<Integer>();
                        List<Element> valueElements = fixedElement.element(
                                "enumeration").elements("value");
                        int label = 0;
                        for (Element valueElement : valueElements) {
                            domain.getValues().put(
                                    Integer.valueOf(label),
                                    Integer.valueOf(valueElement.getText()
                                            .trim()));
                            ++label;
                        }
                        factor.setDomain(domain);
                    }
                    scenario.getFactors().add(factor);
                }
            }
            scenarios.getScenarios().add(scenario);
        }

        return scenarios;
    }*/
}
