/*
 * #%L
 * IsisFish
 * 
 * $Id: PopulationGrowthReverse.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.equation;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.Args;

/**
 * PopulationGrowthReverse.java
 *
 * Created: 23 août 2006 01:26:37
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public interface PopulationGrowthReverse {

    /**
     * 
     * @param context
     * @param length la longueur du groupe
     * @param group le groupe dont on souhaite avoir l'age en fonction de la longueur
     * @return l'age du groupe en mois
     */
    @Args({"context", "length", "group"})
    public double compute(SimulationContext context, double length, PopulationGroup group) throws Exception;

}


