/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TargetSpeciesAbstract extends TopiaEntityAbstract implements TargetSpecies {

    protected Equation targetFactorEquation;
    /**
     * <p>Vrai si la MetaPopulation est une esp&egrave;ce vis&eacute;e prioritairement</p>


     */
    protected boolean primaryCatch;
    public Species species;
    public MetierSeasonInfo metierSeasonInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TargetSpecies.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, TARGET_FACTOR_EQUATION, Equation.class, targetFactorEquation);
        visitor.visit(this, PRIMARY_CATCH, boolean.class, primaryCatch);
        visitor.visit(this, SPECIES, Species.class, species);
        visitor.visit(this, METIER_SEASON_INFO, MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTargetFactorEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setTargetFactorEquation :
     * @param value 
     */

    public void setTargetFactorEquation(Equation value) {
        Equation _oldValue = this.targetFactorEquation;
        fireOnPreWrite(TARGET_FACTOR_EQUATION, _oldValue, value);
        this.targetFactorEquation = value;
        fireOnPostWrite(TARGET_FACTOR_EQUATION, _oldValue, value);
}

    /**
     * getTargetFactorEquation :
     * @return Equation 
     */

    public Equation getTargetFactorEquation() {
        fireOnPreRead(TARGET_FACTOR_EQUATION, targetFactorEquation);
        Equation result = this.targetFactorEquation;
        fireOnPostRead(TARGET_FACTOR_EQUATION, targetFactorEquation);
        return result;
}

    /**
     * setPrimaryCatch :
     * @param value 
     */

    public void setPrimaryCatch(boolean value) {
        boolean _oldValue = this.primaryCatch;
        fireOnPreWrite(PRIMARY_CATCH, _oldValue, value);
        this.primaryCatch = value;
        fireOnPostWrite(PRIMARY_CATCH, _oldValue, value);
}

    /**
     * getPrimaryCatch :
     * @return boolean 
     */

    public boolean getPrimaryCatch() {
        fireOnPreRead(PRIMARY_CATCH, primaryCatch);
        boolean result = this.primaryCatch;
        fireOnPostRead(PRIMARY_CATCH, primaryCatch);
        return result;
}

    /**
     * setSpecies :
     * @param value La valeur de l'attribut species à positionner.
     */

    public void setSpecies(Species value) {
        Species _oldValue = this.species;
        fireOnPreWrite("species", _oldValue, value);
        this.species = value;
        fireOnPostWrite("species", _oldValue, value);
}

    /**
     * getSpecies :
     * @return Species 
     */

    public Species getSpecies() {    
        return species;
}

    /**
     * setMetierSeasonInfo :
     * @param value La valeur de l'attribut metierSeasonInfo à positionner.
     */

    public void setMetierSeasonInfo(MetierSeasonInfo value) {
        MetierSeasonInfo _oldValue = this.metierSeasonInfo;
        fireOnPreWrite("metierSeasonInfo", _oldValue, value);
        this.metierSeasonInfo = value;
        fireOnPostWrite("metierSeasonInfo", _oldValue, value);
}

    /**
     * getMetierSeasonInfo :
     * @return MetierSeasonInfo 
     */

    public MetierSeasonInfo getMetierSeasonInfo() {    
        return metierSeasonInfo;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(TARGET_FACTOR_EQUATION, this.targetFactorEquation).
            append(PRIMARY_CATCH, this.primaryCatch).
         toString();
        return result;
}


} //TargetSpeciesAbstract
