/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)StrategyMonthInfo.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByMonth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut month le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMonth(Month v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.MONTH, v);
        return result;
    }

    /**
     * findAllByMonth :
     * Retourne les éléments ayant comme valeur pour l'attribut month le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMonth(Month v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.MONTH, v);
        return result;
    }

    /**
     * findByMinInactivityDays :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minInactivityDays le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinInactivityDays(double v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.MIN_INACTIVITY_DAYS, v);
        return result;
    }

    /**
     * findAllByMinInactivityDays :
     * Retourne les éléments ayant comme valeur pour l'attribut minInactivityDays le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinInactivityDays(double v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.MIN_INACTIVITY_DAYS, v);
        return result;
    }

    /**
     * findByNumberOfTrips :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut numberOfTrips le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNumberOfTrips(double v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.NUMBER_OF_TRIPS, v);
        return result;
    }

    /**
     * findAllByNumberOfTrips :
     * Retourne les éléments ayant comme valeur pour l'attribut numberOfTrips le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNumberOfTrips(double v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.NUMBER_OF_TRIPS, v);
        return result;
    }

    /**
     * findByProportionMetier :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut proportionMetier le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByProportionMetier(MatrixND v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.PROPORTION_METIER, v);
        return result;
    }

    /**
     * findAllByProportionMetier :
     * Retourne les éléments ayant comme valeur pour l'attribut proportionMetier le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByProportionMetier(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.PROPORTION_METIER, v);
        return result;
    }

    /**
     * findByTripType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut tripType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTripType(TripType v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.TRIP_TYPE, v);
        return result;
    }

    /**
     * findAllByTripType :
     * Retourne les éléments ayant comme valeur pour l'attribut tripType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTripType(TripType v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.TRIP_TYPE, v);
        return result;
    }

    /**
     * findByStrategy :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut strategy le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByStrategy(Strategy v) throws TopiaException {
        E result = findByProperty(StrategyMonthInfo.STRATEGY, v);
        return result;
    }

    /**
     * findAllByStrategy :
     * Retourne les éléments ayant comme valeur pour l'attribut strategy le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByStrategy(Strategy v) throws TopiaException {
        List<E> result = findAllByProperty(StrategyMonthInfo.STRATEGY, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllContainsStrategyMonthInfo(entity);
//            tmp = dao.findAllByProperties(Strategy.STRATEGY_MONTH_INFO, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        return result;
    }


} //StrategyMonthInfoDAOAbstract<E extends StrategyMonthInfo>
