/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class StrategyDAOAbstract<E extends Strategy> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Strategy.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<StrategyMonthInfo> list = getContext()
                                                    .getDAO(StrategyMonthInfo.class)
                                                    .findAllByProperties(StrategyMonthInfo.STRATEGY, entity);
                        //                            .findAllByProperties("strategy", entity);
                                            for (StrategyMonthInfo item : list) {
                                                item.setStrategy(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Strategy.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.NAME, v);
        return result;
    }

    /**
     * findByProportionSetOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut proportionSetOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByProportionSetOfVessels(double v) throws TopiaException {
        E result = findByProperty(Strategy.PROPORTION_SET_OF_VESSELS, v);
        return result;
    }

    /**
     * findAllByProportionSetOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut proportionSetOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByProportionSetOfVessels(double v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.PROPORTION_SET_OF_VESSELS, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Strategy.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.COMMENT, v);
        return result;
    }

    /**
     * findByInactivityEquationUsed :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut inactivityEquationUsed le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInactivityEquationUsed(boolean v) throws TopiaException {
        E result = findByProperty(Strategy.INACTIVITY_EQUATION_USED, v);
        return result;
    }

    /**
     * findAllByInactivityEquationUsed :
     * Retourne les éléments ayant comme valeur pour l'attribut inactivityEquationUsed le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInactivityEquationUsed(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.INACTIVITY_EQUATION_USED, v);
        return result;
    }

    /**
     * findByInactivityEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut inactivityEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByInactivityEquation(Equation v) throws TopiaException {
        E result = findByProperty(Strategy.INACTIVITY_EQUATION, v);
        return result;
    }

    /**
     * findAllByInactivityEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut inactivityEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByInactivityEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.INACTIVITY_EQUATION, v);
        return result;
    }

    /**
     * findBySetOfVessels :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut setOfVessels le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySetOfVessels(SetOfVessels v) throws TopiaException {
        E result = findByProperty(Strategy.SET_OF_VESSELS, v);
        return result;
    }

    /**
     * findAllBySetOfVessels :
     * Retourne les éléments ayant comme valeur pour l'attribut setOfVessels le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySetOfVessels(SetOfVessels v) throws TopiaException {
        List<E> result = findAllByProperty(Strategy.SET_OF_VESSELS, v);
        return result;
    }

    /**
     * findContainsStrategyMonthInfo :
     * Retourne le premier élément trouvé dont l'attribut strategyMonthInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsStrategyMonthInfo(StrategyMonthInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Strategy.STRATEGY_MONTH_INFO, Arrays.asList(v));
        E result = findContainsProperties("strategyMonthInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsStrategyMonthInfo :
     * Retourne les éléments trouvé dont l'attribut strategyMonthInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsStrategyMonthInfo(StrategyMonthInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Strategy.STRATEGY_MONTH_INFO, Arrays.asList(v));
        List<E> results = findAllContainsProperties("strategyMonthInfo", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == StrategyMonthInfo.class) {
            StrategyMonthInfoDAO dao = (StrategyMonthInfoDAO)
                getContext().getDAO(StrategyMonthInfo.class);
            tmp = dao.findAllByStrategy(entity);
//            tmp = dao.findAllByProperties(StrategyMonthInfo.STRATEGY, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(StrategyMonthInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(StrategyMonthInfo.class, list);
        }

        return result;
    }


} //StrategyDAOAbstract<E extends Strategy>
