/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SetOfVesselsAbstract extends TopiaEntityAbstract implements SetOfVessels {

    protected String name;
    protected int numberOfVessels;
    /**
     * <p>Co&ucirc;ts fixes d&eacute;caiss&eacute;s</p>


     */
    protected double fixedCosts;
    protected double vesselCosts;
    protected double capitalDeprecation;
    protected double interestCost;
    protected String comment;
    protected Equation technicalEfficiencyEquation;
    protected Port port;
    protected Collection<EffortDescription> possibleMetiers;
    protected VesselType vesselType;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(SetOfVessels.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, NUMBER_OF_VESSELS, int.class, numberOfVessels);
        visitor.visit(this, FIXED_COSTS, double.class, fixedCosts);
        visitor.visit(this, VESSEL_COSTS, double.class, vesselCosts);
        visitor.visit(this, CAPITAL_DEPRECATION, double.class, capitalDeprecation);
        visitor.visit(this, INTEREST_COST, double.class, interestCost);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, TECHNICAL_EFFICIENCY_EQUATION, Equation.class, technicalEfficiencyEquation);
        visitor.visit(this, PORT, Port.class, port);
        visitor.visit(this, POSSIBLE_METIERS, java.util.Collection.class, EffortDescription.class, possibleMetiers);
        visitor.visit(this, VESSEL_TYPE, VesselType.class, vesselType);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getTechnicalEfficiencyEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("setOfVessels", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setNumberOfVessels :
     * @param value 
     */

    public void setNumberOfVessels(int value) {
        int _oldValue = this.numberOfVessels;
        fireOnPreWrite(NUMBER_OF_VESSELS, _oldValue, value);
        this.numberOfVessels = value;
        fireOnPostWrite(NUMBER_OF_VESSELS, _oldValue, value);
}

    /**
     * getNumberOfVessels :
     * @return int 
     */

    public int getNumberOfVessels() {
        fireOnPreRead(NUMBER_OF_VESSELS, numberOfVessels);
        int result = this.numberOfVessels;
        fireOnPostRead(NUMBER_OF_VESSELS, numberOfVessels);
        return result;
}

    /**
     * setFixedCosts :
     * @param value 
     */

    public void setFixedCosts(double value) {
        double _oldValue = this.fixedCosts;
        fireOnPreWrite(FIXED_COSTS, _oldValue, value);
        this.fixedCosts = value;
        fireOnPostWrite(FIXED_COSTS, _oldValue, value);
}

    /**
     * getFixedCosts :
     * @return double 
     */

    public double getFixedCosts() {
        fireOnPreRead(FIXED_COSTS, fixedCosts);
        double result = this.fixedCosts;
        fireOnPostRead(FIXED_COSTS, fixedCosts);
        return result;
}

    /**
     * setVesselCosts :
     * @param value 
     */

    public void setVesselCosts(double value) {
        double _oldValue = this.vesselCosts;
        fireOnPreWrite(VESSEL_COSTS, _oldValue, value);
        this.vesselCosts = value;
        fireOnPostWrite(VESSEL_COSTS, _oldValue, value);
}

    /**
     * getVesselCosts :
     * @return double 
     */

    public double getVesselCosts() {
        fireOnPreRead(VESSEL_COSTS, vesselCosts);
        double result = this.vesselCosts;
        fireOnPostRead(VESSEL_COSTS, vesselCosts);
        return result;
}

    /**
     * setCapitalDeprecation :
     * @param value 
     */

    public void setCapitalDeprecation(double value) {
        double _oldValue = this.capitalDeprecation;
        fireOnPreWrite(CAPITAL_DEPRECATION, _oldValue, value);
        this.capitalDeprecation = value;
        fireOnPostWrite(CAPITAL_DEPRECATION, _oldValue, value);
}

    /**
     * getCapitalDeprecation :
     * @return double 
     */

    public double getCapitalDeprecation() {
        fireOnPreRead(CAPITAL_DEPRECATION, capitalDeprecation);
        double result = this.capitalDeprecation;
        fireOnPostRead(CAPITAL_DEPRECATION, capitalDeprecation);
        return result;
}

    /**
     * setInterestCost :
     * @param value 
     */

    public void setInterestCost(double value) {
        double _oldValue = this.interestCost;
        fireOnPreWrite(INTEREST_COST, _oldValue, value);
        this.interestCost = value;
        fireOnPostWrite(INTEREST_COST, _oldValue, value);
}

    /**
     * getInterestCost :
     * @return double 
     */

    public double getInterestCost() {
        fireOnPreRead(INTEREST_COST, interestCost);
        double result = this.interestCost;
        fireOnPostRead(INTEREST_COST, interestCost);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * setTechnicalEfficiencyEquation :
     * @param value 
     */

    public void setTechnicalEfficiencyEquation(Equation value) {
        Equation _oldValue = this.technicalEfficiencyEquation;
        fireOnPreWrite(TECHNICAL_EFFICIENCY_EQUATION, _oldValue, value);
        this.technicalEfficiencyEquation = value;
        fireOnPostWrite(TECHNICAL_EFFICIENCY_EQUATION, _oldValue, value);
}

    /**
     * getTechnicalEfficiencyEquation :
     * @return Equation 
     */

    public Equation getTechnicalEfficiencyEquation() {
        fireOnPreRead(TECHNICAL_EFFICIENCY_EQUATION, technicalEfficiencyEquation);
        Equation result = this.technicalEfficiencyEquation;
        fireOnPostRead(TECHNICAL_EFFICIENCY_EQUATION, technicalEfficiencyEquation);
        return result;
}

    /**
     * setPort :
     * @param value 
     */

    public void setPort(Port value) {
        Port _oldValue = this.port;
        fireOnPreWrite(PORT, _oldValue, value);
        this.port = value;
        fireOnPostWrite(PORT, _oldValue, value);
}

    /**
     * getPort :
     * @return Port 
     */

    public Port getPort() {
        fireOnPreRead(PORT, port);
        Port result = this.port;
        fireOnPostRead(PORT, port);
        return result;
}

    /**
     * addPossibleMetiers :
     * @param value 
     */

    public void addPossibleMetiers(EffortDescription value) {
        fireOnPreWrite(POSSIBLE_METIERS, null, value);
        if (this.possibleMetiers == null) {
            this.possibleMetiers = new ArrayList<fr.ifremer.isisfish.entities.EffortDescription>();
        }
        this.possibleMetiers.add(value);
        fireOnPostWrite(POSSIBLE_METIERS, this.possibleMetiers.size(), null, value);
}

    /**
     * getPossibleMetiersByTopiaId :
     * @param topiaId 
     * @return EffortDescription 
     */

    public EffortDescription getPossibleMetiersByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(possibleMetiers, topiaId);
}

    /**
     * addAllPossibleMetiers :
     * @param values 
     */

    public void addAllPossibleMetiers(Collection<EffortDescription> values) {
        if (values == null) {
            return;
        }
        for (fr.ifremer.isisfish.entities.EffortDescription item : values) {
            addPossibleMetiers(item);
        }
}

    /**
     * setPossibleMetiers :
     * @param values 
     */

    public void setPossibleMetiers(Collection<EffortDescription> values) {
//        clearPossibleMetiers();
//        addAllPossibleMetiers(values);
// FIXME
        Collection<fr.ifremer.isisfish.entities.EffortDescription> _oldValue = possibleMetiers;
        fireOnPreWrite(POSSIBLE_METIERS, _oldValue, values);
        possibleMetiers = values;
        fireOnPostWrite(POSSIBLE_METIERS, _oldValue, values);
}

    /**
     * removePossibleMetiers :
     * @param value 
     */

    public void removePossibleMetiers(EffortDescription value) {
        fireOnPreWrite(POSSIBLE_METIERS, value, null);
        if ((this.possibleMetiers == null) || (!this.possibleMetiers.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(POSSIBLE_METIERS, this.possibleMetiers.size()+1, value, null);
}

    /**
     * clearPossibleMetiers :
     */

    public void clearPossibleMetiers() {
        if (this.possibleMetiers == null) {
            return;
        }
        Collection<fr.ifremer.isisfish.entities.EffortDescription> _oldValue = new ArrayList<fr.ifremer.isisfish.entities.EffortDescription>(this.possibleMetiers);
        fireOnPreWrite(POSSIBLE_METIERS, _oldValue, null);
        this.possibleMetiers.clear();
        fireOnPostWrite(POSSIBLE_METIERS, _oldValue, null);
}

    /**
     * getPossibleMetiers :
     * @return Collection<EffortDescription> 
     */

    public Collection<EffortDescription> getPossibleMetiers() {
        return possibleMetiers;
}

    /**
     * getPossibleMetiers :
     * @param value 
     * @return EffortDescription 
     */

    public EffortDescription getPossibleMetiers(Metier value) {
        if (value == null || possibleMetiers == null) {
            return null;
        }
        for (fr.ifremer.isisfish.entities.EffortDescription item : possibleMetiers) {
            if (value.equals(item.getPossibleMetiers())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizePossibleMetiers :
     * @return int 
     */

    public int sizePossibleMetiers() {
        if (possibleMetiers == null) {
            return 0;
        }
        return possibleMetiers.size();
}

    /**
     * isPossibleMetiersEmpty :
     * @return boolean 
     */

    public boolean isPossibleMetiersEmpty() {
        int size = sizePossibleMetiers();
        return size == 0;
}

    /**
     * setVesselType :
     * @param value 
     */

    public void setVesselType(VesselType value) {
        VesselType _oldValue = this.vesselType;
        fireOnPreWrite(VESSEL_TYPE, _oldValue, value);
        this.vesselType = value;
        fireOnPostWrite(VESSEL_TYPE, _oldValue, value);
}

    /**
     * getVesselType :
     * @return VesselType 
     */

    public VesselType getVesselType() {
        fireOnPreRead(VESSEL_TYPE, vesselType);
        VesselType result = this.vesselType;
        fireOnPostRead(VESSEL_TYPE, vesselType);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(NUMBER_OF_VESSELS, this.numberOfVessels).
            append(FIXED_COSTS, this.fixedCosts).
            append(VESSEL_COSTS, this.vesselCosts).
            append(CAPITAL_DEPRECATION, this.capitalDeprecation).
            append(INTEREST_COST, this.interestCost).
            append(COMMENT, this.comment).
            append(TECHNICAL_EFFICIENCY_EQUATION, this.technicalEfficiencyEquation).
            append(PORT, this.port).
            append(VESSEL_TYPE, this.vesselType).
         toString();
        return result;
}


} //SetOfVesselsAbstract
