/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PortDAOAbstract<E extends Port> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Port.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SetOfVessels> list = getContext()
                                                    .getDAO(SetOfVessels.class)
                                                    .findAllByProperties(SetOfVessels.PORT, entity);
                        //                            .findAllByProperties("port", entity);
                                            for (SetOfVessels item : list) {
                                                item.setPort(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Port.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Port.NAME, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Port.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Port.COMMENT, v);
        return result;
    }

    /**
     * findByCell :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cell le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCell(Cell v) throws TopiaException {
        E result = findByProperty(Port.CELL, v);
        return result;
    }

    /**
     * findAllByCell :
     * Retourne les éléments ayant comme valeur pour l'attribut cell le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCell(Cell v) throws TopiaException {
        List<E> result = findAllByProperty(Port.CELL, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SetOfVessels.class) {
            SetOfVesselsDAO dao = (SetOfVesselsDAO)
                getContext().getDAO(SetOfVessels.class);
            tmp = dao.findAllByPort(entity);
//            tmp = dao.findAllByProperties(SetOfVessels.PORT, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(SetOfVessels.class, entity);
        if (!list.isEmpty()) {
            result.put(SetOfVessels.class, list);
        }

        return result;
    }


} //PortDAOAbstract<E extends Port>
