/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  boolFields={PopulationSeasonInfo.GROUP_CHANGE, PopulationSeasonInfo.SIMPLE_LENGTH_CHANGE_MATRIX, PopulationSeasonInfo.REPRODUCTION, PopulationSeasonInfo.USE_EQUATION_MIGRATION}
)

public interface PopulationSeasonInfo extends Season, TopiaEntity {     String REPRODUCTION_DISTRIBUTION = "reproductionDistribution";
     String GROUP_CHANGE = "groupChange";
     String SIMPLE_LENGTH_CHANGE_MATRIX = "simpleLengthChangeMatrix";
     String LENGTH_CHANGE_MATRIX = "lengthChangeMatrix";
     String REPRODUCTION = "reproduction";
     String USE_EQUATION_MIGRATION = "useEquationMigration";
     String MIGRATION_MATRIX = "migrationMatrix";
     String EMIGRATION_MATRIX = "emigrationMatrix";
     String IMMIGRATION_MATRIX = "immigrationMatrix";
     String MIGRATION_EQUATION = "migrationEquation";
     String EMIGRATION_EQUATION = "emigrationEquation";
     String IMMIGRATION_EQUATION = "immigrationEquation";
     String POPULATION = "population";
    /**
     * setReproductionDistribution :
     * <p>Matrice repr&eacute;sentant la distribution de la reproduction sur les diff&eacute;rents mois de la saison.</p>
     * @param reproductionDistribution La valeur de l'attribut reproductionDistribution à positionner.
     */

     void setReproductionDistribution(MatrixND reproductionDistribution);

    /**
     * getReproductionDistribution :
     * <p>Matrice repr&eacute;sentant la distribution de la reproduction sur les diff&eacute;rents mois de la saison.</p>
     * @return MatrixND 
     */

     MatrixND getReproductionDistribution();

    /**
     * setGroupChange :
     * <p>Si vrai alors la population change de groupe d'age ou de longueurs en debut de saison</p>

     * @param groupChange La valeur de l'attribut groupChange à positionner.
     */

     void setGroupChange(boolean groupChange);

    /**
     * getGroupChange :
     * <p>Si vrai alors la population change de groupe d'age ou de longueurs en debut de saison</p>

     * @return boolean 
     */

     boolean getGroupChange();

    /**
     * setSimpleLengthChangeMatrix :
     * <p>Indique si la matrice de changementde longeur est une matrice simple ou complexe</p>

     * @param simpleLengthChangeMatrix La valeur de l'attribut simpleLengthChangeMatrix à positionner.
     */

     void setSimpleLengthChangeMatrix(boolean simpleLengthChangeMatrix);

    /**
     * getSimpleLengthChangeMatrix :
     * <p>Indique si la matrice de changementde longeur est une matrice simple ou complexe</p>

     * @return boolean 
     */

     boolean getSimpleLengthChangeMatrix();

    /**
     * setLengthChangeMatrix :
     * <p>La matrice de changement de longueur. Appliquable que si la MetaPopulation est en longueur. Cette matrice est [group x group] ou [ (group, zone) x ( group, zone)]</p>
<p></p>
     * @param lengthChangeMatrix La valeur de l'attribut lengthChangeMatrix à positionner.
     */

     void setLengthChangeMatrix(MatrixND lengthChangeMatrix);

    /**
     * getLengthChangeMatrix :
     * <p>La matrice de changement de longueur. Appliquable que si la MetaPopulation est en longueur. Cette matrice est [group x group] ou [ (group, zone) x ( group, zone)]</p>
<p></p>
     * @return MatrixND 
     */

     MatrixND getLengthChangeMatrix();

    /**
     * setReproduction :
     * <p>Indique s'il y a de la reproduction durant la saison</p>

     * @param reproduction La valeur de l'attribut reproduction à positionner.
     */

     void setReproduction(boolean reproduction);

    /**
     * getReproduction :
     * <p>Indique s'il y a de la reproduction durant la saison</p>

     * @return boolean 
     */

     boolean getReproduction();

    /**
     * setUseEquationMigration :
     * @param useEquationMigration La valeur de l'attribut useEquationMigration à positionner.
     */

     void setUseEquationMigration(boolean useEquationMigration);

    /**
     * getUseEquationMigration :
     * @return boolean 
     */

     boolean getUseEquationMigration();

    /**
     * setMigrationMatrix :
     * <p>Matrix [group x zone(left) x zone(reached)]</p>
     * @param migrationMatrix La valeur de l'attribut migrationMatrix à positionner.
     */

     void setMigrationMatrix(MatrixND migrationMatrix);

    /**
     * getMigrationMatrix :
     * <p>Matrix [group x zone(left) x zone(reached)]</p>
     * @return MatrixND 
     */

     MatrixND getMigrationMatrix();

    /**
     * setEmigrationMatrix :
     * <p>Matrix [group x zone(left)]</p>
     * @param emigrationMatrix La valeur de l'attribut emigrationMatrix à positionner.
     */

     void setEmigrationMatrix(MatrixND emigrationMatrix);

    /**
     * getEmigrationMatrix :
     * <p>Matrix [group x zone(left)]</p>
     * @return MatrixND 
     */

     MatrixND getEmigrationMatrix();

    /**
     * setImmigrationMatrix :
     * <p>Matrix [group x zone(reached)]</p>
     * @param immigrationMatrix La valeur de l'attribut immigrationMatrix à positionner.
     */

     void setImmigrationMatrix(MatrixND immigrationMatrix);

    /**
     * getImmigrationMatrix :
     * <p>Matrix [group x zone(reached)]</p>
     * @return MatrixND 
     */

     MatrixND getImmigrationMatrix();

    /**
     * setMigrationEquation :
     * @param migrationEquation La valeur de l'attribut migrationEquation à positionner.
     */

     void setMigrationEquation(Equation migrationEquation);

    /**
     * getMigrationEquation :
     * @return Equation 
     */

     Equation getMigrationEquation();

    /**
     * setEmigrationEquation :
     * @param emigrationEquation La valeur de l'attribut emigrationEquation à positionner.
     */

     void setEmigrationEquation(Equation emigrationEquation);

    /**
     * getEmigrationEquation :
     * @return Equation 
     */

     Equation getEmigrationEquation();

    /**
     * setImmigrationEquation :
     * @param immigrationEquation La valeur de l'attribut immigrationEquation à positionner.
     */

     void setImmigrationEquation(Equation immigrationEquation);

    /**
     * getImmigrationEquation :
     * @return Equation 
     */

     Equation getImmigrationEquation();

    /**
     * setPopulation :
     * @param population La valeur de l'attribut population à positionner.
     */

     void setPopulation(Population population);

    /**
     * getPopulation :
     * @return Population 
     */

     Population getPopulation();

    /**
     * getCapturability :
     * @param group 
     * @return double 
     */

     double getCapturability(PopulationGroup group);

    /**
     * spacializeLengthChangeMatrix :
     * @param mat 
     * @return MatrixND 
     */

     MatrixND spacializeLengthChangeMatrix(MatrixND mat);

    /**
     * computeLengthChangeMatrix :
     * @return MatrixND 
     */

     MatrixND computeLengthChangeMatrix();

    /**
     * getGroupChangeMatrix :
     * @param month 
     * @return MatrixND 
     */

     MatrixND getGroupChangeMatrix(Month month);

    /**
     * getMigrationMatrix :
     * <p>Matrix [(group, zone(left)) x (group, zone(reached))]</p>
     * @param month 
     * @param N 
     * @return MatrixND 
     */

     MatrixND getMigrationMatrix(Month month, MatrixND N);

    /**
     * getEmigrationMatrix :
     * <p>Matrix [(group, zone(left)) x (group, zone(left))]</p>
     * @param month 
     * @param N 
     * @return MatrixND 
     */

     MatrixND getEmigrationMatrix(Month month, MatrixND N);

    /**
     * getImmigrationMatrix :
     * <p>Matrix [(group, zone(reached)) x (group, zone(reached))]</p>
     * @param month 
     * @param N 
     * @return MatrixND 
     */

     MatrixND getImmigrationMatrix(Month month, MatrixND N);

    /**
     * getReproductionMatrix :
     * <p>Matrix [zone(repro)]</p>
     * @param month 
     * @param N 
     * @return MatrixND 
     */

     MatrixND getReproductionMatrix(Month month, MatrixND N);

    /**
     * unspacializeLengthChangeMatrix :
     * @param mat 
     * @return MatrixND 
     */

     MatrixND unspacializeLengthChangeMatrix(MatrixND mat);


} //PopulationSeasonInfo
