/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.Collection;
import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={MetierSeasonInfo.SEASON_ZONE_COMMENT, MetierSeasonInfo.COMMENT}
)

public interface MetierSeasonInfo extends Season, TopiaEntity {     String SEASON_ZONE_COMMENT = "seasonZoneComment";
     String COMMENT = "comment";
     String SPECIES_TARGET_SPECIES = "speciesTargetSpecies";
     String METIER = "metier";
     String ZONE = "zone";
    /**
     * setSeasonZoneComment :
     * @param seasonZoneComment La valeur de l'attribut seasonZoneComment à positionner.
     */

     void setSeasonZoneComment(String seasonZoneComment);

    /**
     * getSeasonZoneComment :
     * @return String 
     */

     String getSeasonZoneComment();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * addSpeciesTargetSpecies :
     * @param targetSpecies L'instance de TargetSpecies à ajouter
     */

     void addSpeciesTargetSpecies(TargetSpecies targetSpecies);

    /**
     * addAllSpeciesTargetSpecies :
     * @param targetSpecies Les instances de TargetSpecies à ajouter
     */

     void addAllSpeciesTargetSpecies(Collection<TargetSpecies> targetSpecies);

    /**
     * setSpeciesTargetSpecies :
     * @param targetSpecies La Collection de TargetSpecies à ajouter
     */

     void setSpeciesTargetSpecies(Collection<TargetSpecies> targetSpecies);

    /**
     * removeSpeciesTargetSpecies :
     * @param targetSpecies L'instance de TargetSpecies à retirer
     */

     void removeSpeciesTargetSpecies(TargetSpecies targetSpecies);

    /**
     * clearSpeciesTargetSpecies :
     * Vide la Collection de TargetSpecies .
     */

     void clearSpeciesTargetSpecies();

    /**
     * getSpeciesTargetSpecies :
     * @return Collection<TargetSpecies> 
     */

     Collection<TargetSpecies> getSpeciesTargetSpecies();

    /**
     * getSpeciesTargetSpeciesByTopiaId :
     * Recupère l'attribut species à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return TargetSpecies 
     */

     TargetSpecies getSpeciesTargetSpeciesByTopiaId(String topiaId);

    /**
     * getSpeciesTargetSpecies :
     * @param value 
     * @return TargetSpecies 
     */

     TargetSpecies getSpeciesTargetSpecies(Species value);

    /**
     * sizeSpeciesTargetSpecies :
     * @return int 
     */

     int sizeSpeciesTargetSpecies();

    /**
     * isSpeciesTargetSpeciesEmpty :
     * @return boolean 
     */

     boolean isSpeciesTargetSpeciesEmpty();

    /**
     * setMetier :
     * @param metier La valeur de l'attribut metier à positionner.
     */

     void setMetier(Metier metier);

    /**
     * getMetier :
     * @return Metier 
     */

     Metier getMetier();

    /**
     * addZone :
     * @param zone L'instance de zone à ajouter
     */

     void addZone(Zone zone);

    /**
     * addAllZone :
     * @param zone Les instances de zone à ajouter
     */

     void addAllZone(Collection<Zone> zone);

    /**
     * setZone :
     * @param zone La Collection de zone à ajouter
     */

     void setZone(Collection<Zone> zone);

    /**
     * removeZone :
     * @param zone Vide la Collection de zone
     */

     void removeZone(Zone zone);

    /**
     * clearZone :
     */

     void clearZone();

    /**
     * getZone :
     * @return Collection<Zone> 
     */

     Collection<Zone> getZone();

    /**
     * getZoneByTopiaId :
     * Recupère l'attribut zone à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Zone 
     */

     Zone getZoneByTopiaId(String topiaId);

    /**
     * sizeZone :
     * Retourne le nombre d'éléments de la collection zone
     * @return int 
     */

     int sizeZone();

    /**
     * isZoneEmpty :
     * Retourne {@code true} si la collection zone est vide.
     * @return boolean 
     */

     boolean isZoneEmpty();

    /**
     * getTargetFactor :
     * @param group 
     * @return double 
     */

     double getTargetFactor(PopulationGroup group);

    /**
     * getCells :
     * @return List<Cell> 
     */

     List<Cell> getCells();


} //MetierSeasonInfo
