/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class MetierDAOAbstract<E extends Metier> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Metier.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<MetierSeasonInfo> list = getContext()
                                                    .getDAO(MetierSeasonInfo.class)
                                                    .findAllByProperties(MetierSeasonInfo.METIER, entity);
                        //                            .findAllByProperties("metier", entity);
                                            for (MetierSeasonInfo item : list) {
                                                item.setMetier(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Metier.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.NAME, v);
        return result;
    }

    /**
     * findByGearParameterValue :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gearParameterValue le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGearParameterValue(String v) throws TopiaException {
        E result = findByProperty(Metier.GEAR_PARAMETER_VALUE, v);
        return result;
    }

    /**
     * findAllByGearParameterValue :
     * Retourne les éléments ayant comme valeur pour l'attribut gearParameterValue le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGearParameterValue(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.GEAR_PARAMETER_VALUE, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Metier.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.COMMENT, v);
        return result;
    }

    /**
     * findByCapturableSpeciesComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturableSpeciesComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturableSpeciesComment(String v) throws TopiaException {
        E result = findByProperty(Metier.CAPTURABLE_SPECIES_COMMENT, v);
        return result;
    }

    /**
     * findAllByCapturableSpeciesComment :
     * Retourne les éléments ayant comme valeur pour l'attribut capturableSpeciesComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturableSpeciesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.CAPTURABLE_SPECIES_COMMENT, v);
        return result;
    }

    /**
     * findByGear :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gear le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGear(Gear v) throws TopiaException {
        E result = findByProperty(Metier.GEAR, v);
        return result;
    }

    /**
     * findAllByGear :
     * Retourne les éléments ayant comme valeur pour l'attribut gear le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGear(Gear v) throws TopiaException {
        List<E> result = findAllByProperty(Metier.GEAR, v);
        return result;
    }

    /**
     * findContainsMetierSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Metier.METIER_SEASON_INFO, Arrays.asList(v));
        E result = findContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsMetierSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Metier.METIER_SEASON_INFO, Arrays.asList(v));
        List<E> results = findAllContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == MetierSeasonInfo.class) {
            MetierSeasonInfoDAO dao = (MetierSeasonInfoDAO)
                getContext().getDAO(MetierSeasonInfo.class);
            tmp = dao.findAllByMetier(entity);
//            tmp = dao.findAllByProperties(MetierSeasonInfo.METIER, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(MetierSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(MetierSeasonInfo.class, list);
        }

        return result;
    }


} //MetierDAOAbstract<E extends Metier>
