/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={FisheryRegion.NAME, FisheryRegion.MAP_FILES, FisheryRegion.COMMENT},
  numFields={FisheryRegion.MIN_LONGITUDE, FisheryRegion.MAX_LONGITUDE, FisheryRegion.MIN_LATITUDE, FisheryRegion.MAX_LATITUDE, FisheryRegion.CELL_LENGTH_LONGITUDE, FisheryRegion.CELL_LENGTH_LATITUDE}
)

public interface FisheryRegion extends TopiaEntity {     String NAME = "name";
     String MIN_LONGITUDE = "minLongitude";
     String MAX_LONGITUDE = "maxLongitude";
     String MIN_LATITUDE = "minLatitude";
     String MAX_LATITUDE = "maxLatitude";
     String CELL_LENGTH_LONGITUDE = "cellLengthLongitude";
     String CELL_LENGTH_LATITUDE = "cellLengthLatitude";
     String MAP_FILES = "mapFiles";
     String COMMENT = "comment";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setMinLongitude :
     * @param minLongitude La valeur de l'attribut minLongitude à positionner.
     */

     void setMinLongitude(float minLongitude);

    /**
     * getMinLongitude :
     * @return float 
     */

     float getMinLongitude();

    /**
     * setMaxLongitude :
     * @param maxLongitude La valeur de l'attribut maxLongitude à positionner.
     */

     void setMaxLongitude(float maxLongitude);

    /**
     * getMaxLongitude :
     * @return float 
     */

     float getMaxLongitude();

    /**
     * setMinLatitude :
     * @param minLatitude La valeur de l'attribut minLatitude à positionner.
     */

     void setMinLatitude(float minLatitude);

    /**
     * getMinLatitude :
     * @return float 
     */

     float getMinLatitude();

    /**
     * setMaxLatitude :
     * @param maxLatitude La valeur de l'attribut maxLatitude à positionner.
     */

     void setMaxLatitude(float maxLatitude);

    /**
     * getMaxLatitude :
     * @return float 
     */

     float getMaxLatitude();

    /**
     * setCellLengthLongitude :
     * @param cellLengthLongitude La valeur de l'attribut cellLengthLongitude à positionner.
     */

     void setCellLengthLongitude(float cellLengthLongitude);

    /**
     * getCellLengthLongitude :
     * @return float 
     */

     float getCellLengthLongitude();

    /**
     * setCellLengthLatitude :
     * @param cellLengthLatitude La valeur de l'attribut cellLengthLatitude à positionner.
     */

     void setCellLengthLatitude(float cellLengthLatitude);

    /**
     * getCellLengthLatitude :
     * @return float 
     */

     float getCellLengthLatitude();

    /**
     * setMapFiles :
     * @param mapFiles La valeur de l'attribut mapFiles à positionner.
     */

     void setMapFiles(String mapFiles);

    /**
     * getMapFiles :
     * @return String 
     */

     String getMapFiles();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * getMapFileList :
     * @return List<String> 
     */

     List<String> getMapFileList();

    /**
     * setMapFileList :
     * @param v 
     */

     void setMapFileList(List<String> v);

    /**
     * getMapFilePath :
     * @return List<String> 
     */

     List<String> getMapFilePath();

    /**
     * getGear :
     * @return List<Gear> 
     */

     List<Gear> getGear();

    /**
     * getCell :
     * @return List<Cell> 
     */

     List<Cell> getCell();

    /**
     * getTripType :
     * @return List<TripType> 
     */

     List<TripType> getTripType();

    /**
     * getVesselType :
     * @return List<VesselType> 
     */

     List<VesselType> getVesselType();

    /**
     * getSpecies :
     * @return List<Species> 
     */

     List<Species> getSpecies();

    /**
     * getZone :
     * @return List<Zone> 
     */

     List<Zone> getZone();

    /**
     * getStrategy :
     * @return List<Strategy> 
     */

     List<Strategy> getStrategy();

    /**
     * getPort :
     * @return List<Port> 
     */

     List<Port> getPort();

    /**
     * getMetier :
     * @return List<Metier> 
     */

     List<Metier> getMetier();

    /**
     * getSetOfVessels :
     * @return List<SetOfVessels> 
     */

     List<SetOfVessels> getSetOfVessels();


} //FisheryRegion
