/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class EquationAbstract extends TopiaEntityAbstract implements Equation {

    protected String name;
    protected String content;
    protected String category;
    protected String language;
    protected Class javaInterface;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Equation.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Equation.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, CONTENT, String.class, content);
        visitor.visit(this, CATEGORY, String.class, category);
        visitor.visit(this, LANGUAGE, String.class, language);
        visitor.visit(this, JAVA_INTERFACE, Class.class, javaInterface);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setContent :
     * @param value 
     */

    public void setContent(String value) {
        String _oldValue = this.content;
        fireOnPreWrite(CONTENT, _oldValue, value);
        this.content = value;
        fireOnPostWrite(CONTENT, _oldValue, value);
}

    /**
     * getContent :
     * @return String 
     */

    public String getContent() {
        fireOnPreRead(CONTENT, content);
        String result = this.content;
        fireOnPostRead(CONTENT, content);
        return result;
}

    /**
     * setCategory :
     * @param value 
     */

    public void setCategory(String value) {
        String _oldValue = this.category;
        fireOnPreWrite(CATEGORY, _oldValue, value);
        this.category = value;
        fireOnPostWrite(CATEGORY, _oldValue, value);
}

    /**
     * getCategory :
     * @return String 
     */

    public String getCategory() {
        fireOnPreRead(CATEGORY, category);
        String result = this.category;
        fireOnPostRead(CATEGORY, category);
        return result;
}

    /**
     * setLanguage :
     * @param value 
     */

    public void setLanguage(String value) {
        String _oldValue = this.language;
        fireOnPreWrite(LANGUAGE, _oldValue, value);
        this.language = value;
        fireOnPostWrite(LANGUAGE, _oldValue, value);
}

    /**
     * getLanguage :
     * @return String 
     */

    public String getLanguage() {
        fireOnPreRead(LANGUAGE, language);
        String result = this.language;
        fireOnPostRead(LANGUAGE, language);
        return result;
}

    /**
     * setJavaInterface :
     * @param value 
     */

    public void setJavaInterface(Class value) {
        Class _oldValue = this.javaInterface;
        fireOnPreWrite(JAVA_INTERFACE, _oldValue, value);
        this.javaInterface = value;
        fireOnPostWrite(JAVA_INTERFACE, _oldValue, value);
}

    /**
     * getJavaInterface :
     * @return Class 
     */

    public Class getJavaInterface() {
        fireOnPreRead(JAVA_INTERFACE, javaInterface);
        Class result = this.javaInterface;
        fireOnPostRead(JAVA_INTERFACE, javaInterface);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(CONTENT, this.content).
            append(CATEGORY, this.category).
            append(LANGUAGE, this.language).
            append(JAVA_INTERFACE, this.javaInterface).
         toString();
        return result;
}


} //EquationAbstract
