/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class CellAbstract extends TopiaEntityAbstract implements Cell {

    protected String name;
    protected float latitude;
    protected float longitude;
    protected boolean land;
    protected String comment;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Cell.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, LATITUDE, float.class, latitude);
        visitor.visit(this, LONGITUDE, float.class, longitude);
        visitor.visit(this, LAND, boolean.class, land);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setLatitude :
     * @param value 
     */

    public void setLatitude(float value) {
        float _oldValue = this.latitude;
        fireOnPreWrite(LATITUDE, _oldValue, value);
        this.latitude = value;
        fireOnPostWrite(LATITUDE, _oldValue, value);
}

    /**
     * getLatitude :
     * @return float 
     */

    public float getLatitude() {
        fireOnPreRead(LATITUDE, latitude);
        float result = this.latitude;
        fireOnPostRead(LATITUDE, latitude);
        return result;
}

    /**
     * setLongitude :
     * @param value 
     */

    public void setLongitude(float value) {
        float _oldValue = this.longitude;
        fireOnPreWrite(LONGITUDE, _oldValue, value);
        this.longitude = value;
        fireOnPostWrite(LONGITUDE, _oldValue, value);
}

    /**
     * getLongitude :
     * @return float 
     */

    public float getLongitude() {
        fireOnPreRead(LONGITUDE, longitude);
        float result = this.longitude;
        fireOnPostRead(LONGITUDE, longitude);
        return result;
}

    /**
     * setLand :
     * @param value 
     */

    public void setLand(boolean value) {
        boolean _oldValue = this.land;
        fireOnPreWrite(LAND, _oldValue, value);
        this.land = value;
        fireOnPostWrite(LAND, _oldValue, value);
}

    /**
     * getLand :
     * @return boolean 
     */

    public boolean getLand() {
        fireOnPreRead(LAND, land);
        boolean result = this.land;
        fireOnPostRead(LAND, land);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(LATITUDE, this.latitude).
            append(LONGITUDE, this.longitude).
            append(LAND, this.land).
            append(COMMENT, this.comment).
         toString();
        return result;
}


} //CellAbstract
