/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import fr.ifremer.echobase.entities.EchoBaseInternalPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserPersistenceContext;
import fr.ifremer.echobase.entities.EchoBaseUserTopiaApplicationContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.ui.EchoBaseApplicationContext;
import fr.ifremer.echobase.ui.EchoBaseInternalDbTransactionFilter;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.EchoBaseUserDbTransactionFilter;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.interceptors.EchoBaseInjectInterceptor;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EchoBaseInjectInterceptor
implements Interceptor {
    private static final Log log = LogFactory.getLog(EchoBaseInjectInterceptor.class);
    private static final long serialVersionUID = 1L;

    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("init " + this));
        }
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof EchoBaseActionSupport) {
            EchoBaseActionSupport echoBaseActionSupport = (EchoBaseActionSupport)action;
            EchoBaseServiceContext serviceContext = this.newServiceContext(invocation, echoBaseActionSupport.getLocale());
            ActionEchobaseAieOC injector = new ActionEchobaseAieOC(this, invocation);
            injector.inject(serviceContext, action);
        }
        return invocation.invoke();
    }

    protected EchoBaseSession getEchoBaseSession(ActionInvocation invocation) {
        return EchoBaseSession.getEchoBaseSession((ActionContext)invocation.getInvocationContext());
    }

    protected EchoBaseApplicationContext getEchoBaseApplicationContext(ActionInvocation invocation) {
        EchoBaseApplicationContext applicationContext = EchoBaseApplicationContext.getApplicationContext((ActionContext)invocation.getInvocationContext());
        Preconditions.checkNotNull((Object)"application context must be initialized before calling an action", (Object)applicationContext);
        return applicationContext;
    }

    protected EchoBaseServiceContext newServiceContext(ActionInvocation invocation, Locale locale) {
        EchoBaseInternalPersistenceContext topiaInternalContext = EchoBaseInternalDbTransactionFilter.getPersistenceContext((ActionContext)invocation.getInvocationContext());
        EchoBaseUserPersistenceContext topiaContext = EchoBaseUserDbTransactionFilter.getPersistenceContext((ActionContext)invocation.getInvocationContext());
        EchoBaseApplicationContext applicationContext = this.getEchoBaseApplicationContext(invocation);
        EchoBaseSession echoBaseSession = this.getEchoBaseSession(invocation);
        EchoBaseUserTopiaApplicationContext workingDbRootContext = echoBaseSession.getUserDbApplicationContext();
        return applicationContext.newServiceContext(locale, topiaInternalContext, topiaContext, workingDbRootContext);
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)("destroy " + this));
        }
    }
}

