/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.removeData;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.services.service.removedata.RemoveDataConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class ConfirmDelete
extends AbstractConfigureAction<RemoveDataConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfirmDelete.class);
    protected Map<String, String> importTypes;
    protected List<String> importLogs;

    public ConfirmDelete() {
        super(RemoveDataConfiguration.class);
    }

    public List<String> getImportLogs() {
        return this.importLogs;
    }

    protected RemoveDataConfiguration createModel() {
        return new RemoveDataConfiguration();
    }

    protected void prepareExecuteAction(RemoveDataConfiguration model) throws IOException {
    }

    protected void prepareInputAction(RemoveDataConfiguration model) {
        this.importTypes = this.decoratorService.decorateEnums((Enum[])ImportType.values());
        this.importLogs = Lists.newArrayList();
        for (String id : model.getImportLogIds()) {
            Optional optionalImportLog;
            if (log.isInfoEnabled()) {
                log.info((Object)("Load import log " + id));
            }
            if (!(optionalImportLog = this.userDbPersistenceService.getOptionalImportLog(id)).isPresent()) continue;
            ImportLog importLog = (ImportLog)optionalImportLog.get();
            String entityDecorated = "";
            String entityId = importLog.getEntityId();
            if (entityId != null) {
                TopiaEntity entity = this.userDbPersistenceService.getEntity(entityId);
                entityDecorated = this.decoratorService.decorate((Object)entity, null);
            }
            String importType = (String)this.importTypes.get(importLog.getImportType().name());
            String result = this.t("echobase.common.importLogToDelete", new Object[]{entityDecorated, importType, importLog.getImportDate()});
            this.importLogs.add(result);
        }
    }
}

