/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportDb;

import fr.ifremer.echobase.services.service.exportdb.ExportDbConfiguration;
import fr.ifremer.echobase.services.service.exportdb.ExportDbService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Export
extends AbstractWaitAndExecAction<ExportDbConfiguration, ExportDbService> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Export.class);

    public Export() {
        super(ExportDbConfiguration.class, ExportDbService.class);
    }

    protected void startAction(ExportDbService service, ExportDbConfiguration model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start export db to file " + model.getFileName()));
        }
        service.doExport(model);
    }

    protected String getSuccesMessage() {
        return this.t("echobase.info.exportDb.succeded", new Object[0]);
    }

    protected String getErrorMessage() {
        return this.t("echobase.info.exportDb.failed", new Object[0]);
    }

    public String getActionResumeTitle() {
        return this.t("echobase.legend.exportDb.resume", new Object[0]);
    }

    protected String getResultMessage(ExportDbConfiguration model) {
        String exportType = this.t(model.getExportDbMode().getI18nKey(), new Object[0]);
        String result = this.t("echobase.message.exportDb.result", new Object[]{exportType, model.getFileName(), model.getActionTime()});
        if (log.isInfoEnabled()) {
            log.info((Object)("Result: " + result));
        }
        return result;
    }
}

