/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportCoser;

import fr.ifremer.echobase.services.service.CoserApiService;
import fr.ifremer.echobase.services.service.CoserIndicators;
import fr.ifremer.echobase.services.service.DecoratorService;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class GetAvailableIndicatorsForMission
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;
    @Inject
    private transient CoserApiService coserApiService;
    @Inject
    protected transient DecoratorService decoratorService;
    protected Map<String, String> communityIndicators;
    protected Map<String, String> populationIndicators;
    protected String missionId;

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public Map<String, String> getCommunityIndicators() {
        return this.communityIndicators;
    }

    public Map<String, String> getPopulationIndicators() {
        return this.populationIndicators;
    }

    public String execute() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.missionId)) {
            this.communityIndicators = Collections.emptyMap();
            this.populationIndicators = Collections.emptyMap();
        } else {
            Set indicatorNames = this.coserApiService.getIndicators();
            List dataMetadatas = this.userDbPersistenceService.getDataMetadatasInName(indicatorNames);
            CoserIndicators coserIndicators = this.userDbPersistenceService.getRegionIndicators(this.missionId, dataMetadatas);
            this.communityIndicators = this.decoratorService.sortAndDecorate((Collection)coserIndicators.getCommunityDataMetadatasList(), null);
            this.populationIndicators = this.decoratorService.sortAndDecorate((Collection)coserIndicators.getPopulationDataMetadatasList(), null);
        }
        return super.execute();
    }
}

