/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportAtlantos;

import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.atlantos.ExportAtlantosConfiguration;
import fr.ifremer.echobase.services.service.atlantos.ExportAtlantosService;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class Configure
extends AbstractConfigureAction<ExportAtlantosConfiguration> {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> voyages;
    private static final Log log = LogFactory.getLog(Configure.class);
    @Inject
    private transient ExportAtlantosService atlantosService;

    public Configure() {
        super(ExportAtlantosConfiguration.class);
    }

    protected ExportAtlantosConfiguration createModel() {
        return new ExportAtlantosConfiguration();
    }

    protected void prepareInputAction(ExportAtlantosConfiguration model) {
        this.voyages = this.userDbPersistenceService.loadSortAndDecorate(Voyage.class);
    }

    protected void prepareExecuteAction(ExportAtlantosConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-ices-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
    }

    public Map<String, String> getVoyages() {
        return this.voyages;
    }
}

