/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.entities.ExportQuery;
import fr.ifremer.echobase.services.service.exportquery.ExportQueryService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEditExportQuery
extends EchoBaseActionSupport {
    private static final Log log = LogFactory.getLog(AbstractEditExportQuery.class);
    private static final long serialVersionUID = 1L;
    protected ExportQuery query;
    protected boolean canUpdateQuery;
    protected boolean queryExist;
    protected Map<String, String> queries;
    @Inject
    protected transient ExportQueryService exportQueryService;

    public ExportQuery getQuery() {
        if (this.query == null) {
            this.query = this.exportQueryService.newExportQuery();
        }
        return this.query;
    }

    public boolean isCanUpdateQuery() {
        return this.canUpdateQuery;
    }

    public boolean isQueryExists() {
        return StringUtils.isNotEmpty((CharSequence)this.getQuery().getTopiaId());
    }

    public boolean isNewQuery() {
        return !this.isQueryExists();
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public String input() throws Exception {
        this.queries = this.exportQueryService.loadSortAndDecorate(ExportQuery.class);
        EchoBaseUser echoBaseUser = this.getEchoBaseSession().getUser();
        boolean bl = this.canUpdateQuery = echoBaseUser.isAdmin() || echoBaseUser.getEmail().equals(this.query.getLastModifiedUser());
        if (this.isNewQuery()) {
            this.addFlashMessage(this.t("echobase.info.new.sqlQuery.inprogress", new Object[0]));
        }
        return "input";
    }

    public String execute() throws Exception {
        this.query = this.exportQueryService.createOrUpdate(this.getQuery(), this.getEchoBaseSession().getUser());
        return "success";
    }

    public void validate() {
        super.validate();
        if (!this.hasFieldErrors()) {
            if (!this.exportQueryService.isQueryNameValid(this.getQuery())) {
                this.addFieldError("query.name", this.t("echobase.error.query.invalid.name", new Object[0]));
            } else if (!this.exportQueryService.isQueryNameAvailable(this.getQuery())) {
                this.addFieldError("query.name", this.t("echobase.error.query.name.already.exists", new Object[0]));
            } else {
                try {
                    this.exportQueryService.testSql(this.getQuery().getSqlQuery());
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Invalid sql ", cause);
                    }
                    this.addFieldError("query.sqlQuery", this.t("echobase.error.invalid.sql", new Object[]{cause.getMessage()}));
                }
            }
        }
    }
}

