<%--
#%L
  EchoBase :: UI
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
--%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:set var="importTooltip">
  <s:text name="echobase.message.clickToShowImportDefail"/>
</s:set>

<script type="text/javascript">

  function loadImportLogDetail(importLogId) {
    $.ajax(
      {
        url:'<s:url action="getDashboardImportLog" namespace="/workingDb"/>',
        data:{importLogId:importLogId},
        async:false,
        dataType:"json",
        success:function (data, textStatus) {

          $('#noImportLogDetail').hide();
          $('#importLogDetail').show();
          var json = data.data;

          if ($('#noVoyageDetail').is(":visible")) {

            // need to load voyage
            loadVoyageDetail(json['voyageId']);
          }

          $('#importLogVoyage').html(json['voyageId_lbl']);
          $('#importLogText').html(json['importText']);
          $('#importLogUser').html(json['importUser']);
          $('#importLogDate').html(json['importDate']);
          $('#importLogImportType').html(json['importType']);
        }
      });
    return false;
  }

  function loadVoyageDetail(voyageId) {
    $.ajax(
      {
        url:'<s:url action="getDashboardVoyage" namespace="/workingDb"/>',
        data:{voyageId:voyageId},
        async:false,
        dataType:"json",
        success:function (data, textStatus) {

          $('#noVoyageDetail').hide();
          $('#voyageDetail').show();
          var json = data.data;

          $('#voyageMission').html(json['mission_lbl']);
          $('#voyageAreaOfOperation').html(json['areaOfOperation_lbl']);
          $('#voyageStartEndPort').html(json['startPort'] + " - " + json['endPort']);
          $('#voyageStartEndDate').html(json['startDate'] + " - " + json['endDate']);
          $('#voyageDatum').html(json['datum']);
          $('#voyageName').html(json['name']);
          $('#voyageDescription').html(json['description']);

        }
      });
    return false;
  }

  function formatImportLogs(cellvalue, options, rowObject) {
    var result = "<ul>";
    var importMapping = rowObject['importLogs'];
    $(cellvalue).each(function () {
      var importId = this;
      var val = importMapping[importId];
      result += "<li><a href='#' title='${importTooltip}' onclick='return loadImportLogDetail(\"" + importId +
                "\")' class='fontsize11'>" + val + "</a></li>";
    });
    result += "</ul>";
    return result;
  }

  function formatVoyageName(cellvalue, options, rowObject) {
    return rowObject['id_lbl'];
  }

  jQuery(document).ready(function () {

    // display voyage infos
    $.addRowSelectTopic('voyages', function () {
      var voyageId = $("tr[aria-selected=true] td[aria-describedby='voyages_id']").text();
      loadVoyageDetail(voyageId);
    });

    $.addClearSelectTopic('voyages', function (event) {

      $('#noImportLogDetail').show();
      $('#importLogDetail').hide();
      $('#noVoyageDetail').show();
      $('#voyageDetail').hide();
    });
    $.addEvenAndOddClasses('voyages');
  });
</script>

<title><s:text name="echobase.title.dashboard"/></title>
<s:url id="loadUrl" action="getDashboardImportLogs" namespace="/workingDb"
       escapeAmp="false"/>
<sjg:grid id="voyages" dataType="json" href="%{loadUrl}" gridModel="datas"
          pager="true" pagerButtons="true" pagerInput="true" navigator="true"
          autowidth="true" rownumbers="false" viewrecords="true"
          navigatorEdit="false" navigatorSearch="false"
          navigatorDelete="false"
          navigatorAdd="false" rowList="10,15,20,50,100,250,500" rowNum="10"
          onSelectRowTopics="voyages-rowSelect"
          onCellSelectTopics="voyages-rowSelect"
          onCompleteTopics="voyages-clearSelect,voyages-CompleteTopics">

  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="name" sortable="true" formatter="formatVoyageName"
                  title="%{getText('echobase.common.voyage')}"/>

  <s:iterator value="%{importTypes}" var="entry">
    <sjg:gridColumn name="importType.%{#entry.name}" sortable="false"
                    title="%{#entry.label}" tooltip="%{#entry.title}"
                    formatter="formatImportLogs"/>
  </s:iterator>
</sjg:grid>
<br/>


<fieldset>
  <legend><s:text name="echobase.title.voyage.detail"/></legend>

  <div id="noVoyageDetail">
    <pre>
      <s:text name="echobase.message.noVoyageSelected"/>
    </pre>
  </div>
  <div id="voyageDetail">

    <s:label key='echobase.common.name' value=''/>
    <pre id='voyageName' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.description' value=''/>
    <pre id='voyageDescription' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.mission' value=''/>
    <pre id='voyageMission' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.areaOfOperation' value=''/>
    <pre id='voyageAreaOfOperation' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.startEndPort' value=''/>
    <pre id='voyageStartEndPort' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.startEndDate' value=''/>
    <pre id='voyageStartEndDate' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.datum' value=''/>
    <pre id='voyageDatum' style="font-weight: bold;"></pre>
    <br/>

  </div>

</fieldset>

<fieldset>
  <legend><s:text name="echobase.title.importLog.detail"/></legend>

  <div id="noImportLogDetail">
    <pre>
      <s:text name="echobase.message.noImportLogSelected"/>
    </pre>
  </div>
  <div id="importLogDetail">

    <s:label key='echobase.common.importType' value=''/>
    <pre id='importLogImportType' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.voyage' value=''/>
    <pre id='importLogVoyage' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.importDate' value=''/>
    <pre id='importLogDate' style="font-weight: bold;"></pre>
    <br/>

    <s:label key='echobase.common.importText' value=''/>
    <div class="floatLeft">
      <pre id='importLogText' style="font-weight: bold;"></pre>
    </div>
    <br/>

    <div class="clearBoth"/>
    <s:label key='echobase.common.importUser' value=''/>
    <pre id='importLogUser' style="font-weight: bold;"></pre>
  </div>

</fieldset>
