/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.embeddedApplication;

import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.service.embeddedapplication.EmbeddedApplicationConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;

public class Configure
extends AbstractConfigureAction<EmbeddedApplicationConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Configure.class);
    protected Map<String, String> voyages;

    public Map<String, String> getVoyages() {
        return this.voyages;
    }

    public Configure() {
        super(EmbeddedApplicationConfiguration.class);
    }

    protected EmbeddedApplicationConfiguration createModel() {
        return new EmbeddedApplicationConfiguration();
    }

    protected void prepareInputAction(EmbeddedApplicationConfiguration model) {
        EchoBaseConfiguration configuration = this.getEchoBaseApplicationContext().getConfiguration();
        Version version = configuration.getApplicationVersion();
        String fileName = "echobase-embedded-" + version.toString();
        model.setFileName(fileName);
        File warLocation = configuration.getWarLocation();
        if (!warLocation.exists()) {
            this.addFlashError(this._("echobase.error.warlocation.notFound", new Object[]{warLocation}));
        }
        model.setWarLocation(warLocation);
        this.voyages = this.workingDbPersistenceService.loadSortAndDecorate(Voyage.class);
        if (MapUtils.isEmpty((Map)this.voyages)) {
            this.addFlashMessage(this._("echobase.info.no.voyagee.found", new Object[0]));
        }
    }

    protected void prepareExecuteAction(EmbeddedApplicationConfiguration model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-embeddedApplication-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        File warLocation = this.getEchoBaseApplicationContext().getConfiguration().getWarLocation();
        model.setWarLocation(warLocation);
    }
}

