package fr.ifremer.echobase.ui.actions.removeData;

/*
 * #%L
 * EchoBase :: UI
 * $Id: ConfirmDelete.java 675 2012-09-20 16:03:59Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/removeData/ConfirmDelete.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.removedata.RemoveDataConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Confirm to delete a import log.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class ConfirmDelete extends AbstractConfigureAction<RemoveDataConfiguration> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ConfirmDelete.class);

    protected Map<String, String> importTypes;

    protected List<String> importLogs;

    public ConfirmDelete() {
        super(RemoveDataConfiguration.class);
    }

    public List<String> getImportLogs() {
        return importLogs;
    }

    @Override
    protected RemoveDataConfiguration createModel() {
        return new RemoveDataConfiguration();
    }

    @Override
    protected void prepareExecuteAction(RemoveDataConfiguration model) throws IOException {

        // nothing special to do here
    }

    @Override
    protected void prepareInputAction(RemoveDataConfiguration model) {

        importTypes = decorateEnums(ImportType.values());

        importLogs = Lists.newArrayList();

        EchoBaseServiceSupport service =
                getService(EchoBaseServiceSupport.class);

        Decorator<Voyage> decorator = getService(DecoratorService.class).getDecorator(getLocale(), Voyage.class, null);

        for (String id : model.getImportLogIds()) {
            if (log.isInfoEnabled()) {
                log.info("Load import log " + id);
            }
            ImportLog importLog = service.getEntityById(ImportLog.class, id);

            Voyage voyageEntity = service.getEntityById(Voyage.class, importLog.getVoyageId());
            String voyage = decorator.toString(voyageEntity);
            String importType = importTypes.get(importLog.getImportType().name());
            String result = _("echobase.common.importLogToDelete",
                              voyage,
                              importType,
                              importLog.getImportDate());
            importLogs.add(result);
        }

    }
}