/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: SelectImportType.java 625 2012-09-06 08:42:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-2.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/SelectImportType.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

import java.util.Map;

/**
 * To select the type of import to configure.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class SelectImportType extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected ImportMode mode;

    /** Universe of possible import modes. */
    protected Map<String, String> modes;

    public Map<String, String> getModes() {
        return modes;
    }

    public ImportMode getMode() {
        return mode;
    }

    public void setMode(ImportMode mode) {
        this.mode = mode;
    }

    @Override
    public String input() throws Exception {
        modes = decorateEnums(ImportMode.values());

        if (mode == null) {
            mode = ImportMode.Common;
        }
        return INPUT;
    }

    @Override
    public String execute() throws Exception {
        return SUCCESS;
    }
}
