/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetDataProcessingsForVoyage.java 587 2012-09-01 11:28:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/GetDataProcessingsForVoyage.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.importdata.ResultsImportService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 * Gets all dataProcessings of the selected voyage.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.4
 */
public class GetDataProcessingsForVoyage extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Selected voyage id. */
    protected String voyageId;

    protected Map<String, String> dataProcessings;

    public void setVoyageId(String voyageId) {
        this.voyageId = voyageId;
    }

    public Map<String, String> getDataProcessings() {
        return dataProcessings;
    }

    @Override
    public String execute() throws Exception {

        if (StringUtils.isEmpty(voyageId)) {
            dataProcessings = Maps.newLinkedHashMap();

        } else {

            ResultsImportService service =
                    getService(ResultsImportService.class);

            Voyage voyage = service.getEntityById(Voyage.class, voyageId);

            Preconditions.checkNotNull(
                    voyage,
                    "Could not find voyage with id " + voyageId);

            dataProcessings = service.getDataProcessings(voyage);
        }

        return SUCCESS;
    }
}