/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: GetExportQueryResult.java 587 2012-09-01 11:28:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/exportQuery/GetExportQueryResult.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.exportQuery;

import fr.ifremer.echobase.services.exportquery.ExportQueryService;
import fr.ifremer.echobase.ui.actions.AbstractJSONPaginedAction;

import java.util.Map;

/**
 * Obtains result of a sql query.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class GetExportQueryResult extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    /** Sql request to execute. */
    protected String sql;

    /** Datas of the given table. */
    protected Map<?, ?>[] datas;

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<?, ?>[] getDatas() {
        return datas;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {
        ExportQueryService service = getService(ExportQueryService.class);
        datas = service.executeSql(sql, pager);
        return SUCCESS;
    }
}
