/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CheckUserIsAdmin.java 15 2011-11-07 10:46:58Z sletellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/interceptors/CheckUserIsAdmin.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.interceptors;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.entities.EchoBaseUser;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;

/**
 * To check if logged user is admin.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class CheckUserIsAdmin extends AbstractCheckInterceptor {

    private static final long serialVersionUID = 1L;

    @Override
    protected boolean doCheck(ActionInvocation invocation) {
        EchoBaseActionSupport action = (EchoBaseActionSupport) invocation.getAction();

        EchoBaseSession echoBaseSession = action.getEchoBaseSession();

        EchoBaseUser user = echoBaseSession.getEchoBaseUser();
        Preconditions.checkNotNull(user, "No user found is session");

        return user.isAdmin();
    }
}
