/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CheckLogguedInterceptor.java 276 2012-01-13 17:29:04Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/interceptors/CheckLogguedInterceptor.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.user.LoginAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * To check user is loggued. If not, then redirect to the {@link #loginAction}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class CheckLogguedInterceptor extends AbstractCheckInterceptor {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CheckLogguedInterceptor.class);

    /** Where to redirect if user is not authenticated. */
    protected String loginAction;

    public void setLoginAction(String loginAction) {
        this.loginAction = loginAction;
    }

    protected static final String URL_PATTERN = "%s?redirectAction=%s";

    @Override
    protected boolean doCheck(ActionInvocation invocation) {
        EchoBaseActionSupport action = (EchoBaseActionSupport) invocation.getAction();

        EchoBaseSession echoBaseSession = action.getEchoBaseSession();
        boolean userLoggued = echoBaseSession.getEchoBaseUser() != null;

        if (!userLoggued) {

            boolean autoLogin =
                    EchoBaseActionSupport.getEchoBaseApplicationContext()
                            .getConfiguration()
                            .getOptionAsBoolean(EchoBaseConfiguration.OPTION_AUTO_LOGIN);

            if (autoLogin) {
                // by-pass login

                if (log.isInfoEnabled()) {
                    log.info("AutotLogin with admin/admin user");
                }
                LoginAction logAction = new LoginAction();
                logAction.setSession(invocation.getInvocationContext().getSession());
                logAction.setEmail("admin");
                logAction.setPassword("admin");
                try {
                    logAction.doLogin();
                } catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Could not auto-login", eee);
                    }
                }
                return true;
            }
            if (log.isInfoEnabled()) {
                log.info("No user loggued!");
            }
        }
        return userLoggued;
    }

    @Override
    protected String getRedirectUrl() {

        String url = String.format(URL_PATTERN,
                                   loginAction,
                                   redirectAction
        );
        return url;
    }

}
