/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConnectToDbInformations.java 521 2012-04-10 22:20:08Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.0/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/user/ConnectToDbInformations.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.user;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.services.EmbeddedApplicationService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaContextFactory;

import java.io.File;
import java.util.Properties;

/**
 * Display a page to show connection details.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class ConnectToDbInformations extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    protected String jdbcUrl;

    protected String jdbcLogin;

    protected String jdbcPassword;

    protected String jdbcDriver;

    protected File jdbcPilot;

    protected boolean askPassword;

    public String getJdbcUrl() {
        return jdbcUrl;
    }

    public String getJdbcLogin() {
        return jdbcLogin;
    }

    public String getJdbcPassword() {
        return jdbcPassword;
    }

    public String getJdbcDriver() {
        return jdbcDriver;
    }

    public File getJdbcPilot() {
        return jdbcPilot;
    }

    public boolean isAskPassword() {
        return askPassword;
    }

    @Override
    public String execute() throws Exception {
        EchoBaseConfiguration configuration =
                getEchoBaseApplicationContext().getConfiguration();
        Properties properties = configuration.getProperties();
        if (configuration.isEmbedded()) {
            jdbcPassword = properties.getProperty(TopiaContextFactory.CONFIG_PASS);
        } else {
            askPassword = true;
            jdbcPassword = "***";
        }
        jdbcUrl = properties.getProperty(TopiaContextFactory.CONFIG_URL);
        jdbcLogin = properties.getProperty(TopiaContextFactory.CONFIG_USER);
        jdbcDriver = properties.getProperty(TopiaContextFactory.CONFIG_DRIVER);

        EmbeddedApplicationService service =
                newService(EmbeddedApplicationService.class);

        String pilotName;

        if ("org.h2.Driver".equals(jdbcDriver)) {
            pilotName = service.getH2PilotFilename(properties);
        } else {
            pilotName = service.getPostgresqlPilotFilename(properties);
        }

        if (StringUtils.isNotEmpty(pilotName)) {
            File driverDirectory = service.getPilotsDirectory(
                    configuration.getDataDirectory());
            jdbcPilot = new File(driverDirectory, pilotName);
        }
        return SUCCESS;
    }
}
