/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CleanEchoBaseSessionInterceptor.java 15 2011-11-07 10:46:58Z sletellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/interceptors/CleanEchoBaseSessionInterceptor.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.interceptors;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.TextParseUtil;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.Collections;
import java.util.Set;

/**
 * Interceptor to remove some stuff from user session.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see EchoBaseSession
 * @since 0.1
 */
public class CleanEchoBaseSessionInterceptor extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CleanEchoBaseSessionInterceptor.class);

    private Set<String> parameters = Collections.emptySet();

    /**
     * <code>parameters</code> to remove from session as comma-separated-values (csv).
     *
     * @param parameters the parameters to set
     */
    public void setParameters(String parameters) {
        this.parameters =
                TextParseUtil.commaDelimitedStringToSet(parameters);
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {

        EchoBaseActionSupport action = (EchoBaseActionSupport) invocation.getAction();

        EchoBaseSession echoBaseSession = action.getEchoBaseSession();

        for (String paramName : parameters) {
            Object value = echoBaseSession.remove(paramName);
            if (log.isDebugEnabled()) {
                log.debug("Removed [" + paramName + "]  : " + value);
            }
        }

        return invocation.invoke();
    }
}
