/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.minbin;

import org.nustaq.serialization.minbin.MBRef;
import org.nustaq.serialization.minbin.MinBin;

public class MBIn {
    MinBin mb;
    protected byte[] bytez;
    protected int pos;
    int count;

    public MBIn(byte[] bytez, int pos) {
        this(MinBin.DefaultInstance, bytez, pos);
    }

    public MBIn(MinBin mb, byte[] bytez, int pos) {
        this.bytez = bytez;
        this.pos = pos;
        this.mb = mb;
        if (bytez != null) {
            this.count = bytez.length;
        }
    }

    public byte readIn() {
        if (this.pos >= this.bytez.length) {
            return 6;
        }
        return this.bytez[this.pos++];
    }

    public byte peekIn() {
        if (this.pos >= this.bytez.length) {
            return 6;
        }
        return this.bytez[this.pos];
    }

    private long readRawInt(byte type) {
        long res = 0L;
        int numBytes = MinBin.extractNumBytes(type);
        int shift = 0;
        for (int i = 0; i < numBytes; ++i) {
            long b = this.readIn() + 256 & 0xFF;
            res += b << shift;
            shift += 8;
        }
        return res;
    }

    public long readInt() {
        byte type = this.readIn();
        if (!MinBin.isPrimitive(type) || MinBin.isArray(type)) {
            --this.pos;
            throw new RuntimeException("no integer based id avaiable:" + type);
        }
        byte numBytes = MinBin.extractNumBytes(type);
        long l = this.readRawInt(type);
        if (MinBin.isSigned(type)) {
            switch (numBytes) {
                case 1: {
                    return (byte)l;
                }
                case 2: {
                    return (short)l;
                }
                case 4: {
                    return (int)l;
                }
                case 8: {
                    return l;
                }
            }
            throw new RuntimeException("Wat?");
        }
        return l;
    }

    public Object readArray() {
        byte type = this.readIn();
        if (!MinBin.isArray(type) || !MinBin.isPrimitive(type)) {
            throw new RuntimeException("not a primitive array " + type);
        }
        int len = (int)this.readInt();
        byte baseType = MinBin.getBaseType(type);
        return this.readArrayRaw(type, len, switch (baseType) {
            case 1 -> new byte[len];
            case 2 -> (Object[])new short[len];
            case 10 -> (Object[])new char[len];
            case 3 -> (Object[])new int[len];
            case 4 -> (Object[])new long[len];
            default -> throw new RuntimeException("unknown array type");
        });
    }

    public Object readArrayRaw(byte type, int len, Object resultingArray) {
        Class<?> componentType = resultingArray.getClass().getComponentType();
        if (componentType == Byte.TYPE) {
            byte[] barr = (byte[])resultingArray;
            for (int i = 0; i < len; ++i) {
                barr[i] = (byte)this.readRawInt(type);
            }
        } else if (componentType == Short.TYPE) {
            short[] sArr = (short[])resultingArray;
            for (int i = 0; i < len; ++i) {
                sArr[i] = (short)this.readRawInt(type);
            }
        } else if (componentType == Character.TYPE) {
            char[] cArr = (char[])resultingArray;
            for (int i = 0; i < len; ++i) {
                cArr[i] = (char)this.readRawInt(type);
            }
        } else if (componentType == Integer.TYPE) {
            int[] iArr = (int[])resultingArray;
            for (int i = 0; i < len; ++i) {
                iArr[i] = (int)this.readRawInt(type);
            }
        } else if (componentType == Long.TYPE) {
            long[] lArr = (long[])resultingArray;
            for (int i = 0; i < len; ++i) {
                lArr[i] = this.readRawInt(type);
            }
        } else if (componentType == Boolean.TYPE) {
            boolean[] boolArr = (boolean[])resultingArray;
            for (int i = 0; i < len; ++i) {
                boolArr[i] = this.readRawInt((byte)1) != 0L;
            }
        } else {
            throw new RuntimeException("unsupported array type " + resultingArray.getClass().getName());
        }
        return resultingArray;
    }

    public Object readTag(byte tag) {
        byte tagId = MinBin.getTagId(tag);
        MinBin.TagSerializer ts = this.mb.getSerializerForId(tagId);
        return ts.readTag(this);
    }

    public Object readObject() {
        byte type = this.peekIn();
        if (type == 6) {
            this.readIn();
            return MinBin.END_MARKER;
        }
        if (MinBin.isPrimitive(type)) {
            if (MinBin.isArray(type)) {
                return this.readArray();
            }
            switch (type) {
                case 1: {
                    return (byte)this.readInt();
                }
                case 2: {
                    return (short)this.readInt();
                }
                case 10: {
                    return Character.valueOf((char)this.readInt());
                }
                case 3: {
                    return (int)this.readInt();
                }
                case 4: {
                    return this.readInt();
                }
            }
            throw new RuntimeException("unexpected primitive type:" + type);
        }
        if (MinBin.getTagId(type) == 9) {
            return new MBRef((Integer)this.readTag(this.readIn()));
        }
        return this.readTag(this.readIn());
    }

    public byte[] getBuffer() {
        return this.bytez;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int newpos) {
        this.pos = newpos;
    }

    public void setBuffer(byte[] buf, int count) {
        this.bytez = buf;
        this.pos = 0;
        this.count = count;
    }

    public void reset() {
        this.setBuffer(this.bytez, this.count);
    }

    public int getCount() {
        return this.count;
    }
}

